<?php

namespace Bloom\Cms\Notification\Http\Controllers;

use App\Http\Controllers\Controller;
use Bloom\Cms\Notification\Data\Services;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Validator;

/**
 * Class ServicesController
 * @package Bloom\Cms\Notification\Http\Controllers
 */
class ServicesController extends Controller
{
    public function index()
    {
        $services = Services::all();

        return view("Mails::services.list_services", compact("services"));
    }

    public function edit(Services $service)
    {
        return view("Mails::services.edit_service", compact("service"));
    }

    public function save(Services $service, Request $request)
    {
        if ($service->exists) {
            $validator = Validator::make($request->all(), [
                'service' => 'required|max:60',
            ]);
            if ($validator->fails()) {
                return back()
                    ->withInput(request()->all())
                    ->withErrors($validator);
            } else {
                try {
                    $count = Services::where('service', $request->service)->count();
                    if ($count > 0) {
                        Session::flash('error', 'Le service existe déjà');

                        return back();
                    } else {
                        Services::where("id", $service->id)->update(["service" => $request->service]);
                        Session::flash('message', 'Le groupe ' . $request->service . ' est bien enregistré');

                        return redirect()->route("admin_mails_service_index");
                    }
                } catch (\Exception $e) {
                    Session::flash('error', 'Une erreur est survenu lors de l\'enregistrement');
                    Log::error('Une erreur est survenu lors de l\'enregistrement: ' . $e->getMessage());

                    return redirect()->route("admin_mails_service_index");
                }
            }
        }
        $validator = Validator::make($request->all(), [
            'service' => 'required|max:60',
        ]);
        if ($validator->fails()) {
            return back()
                ->withInput(request()->all())
                ->withErrors($validator);
        } else {
            try {
                $count = Services::where('service', $request->service)->count();
                if ($count > 0) {
                    Session::flash('error', 'Le service existe déjà');

                    return back();
                } else {
                    $service = new Services();
                    $service->service = $request->service;
                    $service->save();
                    Session::flash('message', 'Le groupe ' . $request->service . ' est bien enregistré');

                    return redirect()->route("admin_mails_service_index");
                }
            } catch (\Exception $e) {
                Session::flash('error', 'Une erreur est survenu lors de l\'enregistrement' . $e->getMessage());
                Log::error('Une erreur est survenu lors de l\'enregistrement: ' . $e->getMessage());

                return redirect()->route("admin_mails_service_index");
            }
        }
    }

    public function modale(Services $service)
    {
        return view("Mails::services.modale", compact("service"));
    }

    public function delete(Services $service)
    {
        if (!$service->delete()) {
            Session::flash('error', 'Une erreur est survenue lors de la suppression du service: ' . $service->service);
            Log::error('Une erreur est survenu lors de la suppression du service: ' . $service->service);
        } else {
            Session::flash('message', 'Suppression réussie du service: ' . $service->service);
        }

        return redirect()->route("admin_mails_service_index");
    }
}
