<?php

namespace Bloom\Cms\Notification;

use Bloom\CMS\Core\BloomProvider;
use Bloom\CMS\Core\Framework\Admin\AdminMenu;
use Bloom\Cms\Notification\Facade\ConfigurationsFacade;
use Illuminate\Support\Facades\Schema;

class CmsNotificationProvider extends BloomProvider
{
    protected $nom = "Mails";
    protected $code = "mails";
    protected $icons = "mail";

    public function boot()
    {
        parent::boot();

        if (Schema::hasTable('conf_services')) {
            $this->app->singleton('notification', function () {
                return new ConfigurationsFacade();
            });
        }

        $this->addSubMenus([
            new AdminMenu([
                'label' => 'Groupe de diffusion',
                'route' => 'admin_mails_service_index',
            ])
        ]);
    }
}
