<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateMailsServicesTables extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('mails_services', function (Blueprint $table) {
            $table->increments('id');
            $table->integer('mails_id', false, true);
            $table->integer('services_id', false, true);
            $table->timestamps();
            $table->foreign(['mails_id'])->references('id')->on('mails')->onDelete('cascade');
            $table->foreign(['services_id'])->references('id')->on('services')->onDelete('cascade');
        });

    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::disableForeignKeyConstraints();
        Schema::dropIfExists('mails_services');
    }
}
