<?php


namespace Bloom\Cms\Notification\Http\Controllers;


use Bloom\Cms\Notification\Data\Mails;
use Bloom\Cms\Notification\Data\Services;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Validator;

class ServicesMailController
{
    public function listMail()
    {
        $mails = Mails::all();

        return view("ConfigModule::mail.list_mail", compact("mails"));
    }

    public function createMail()
    {
        $services = Services::all();
        return view("ConfigModule::mail.edit_mail", compact("services"));
    }

    public function createMailSubmit(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'mail' => 'required|max:60|email',
        ]);
        if ($validator->fails()) {
            return back()
                ->withInput(request()->all())
                ->withErrors($validator);
        } else {
            $count = Mails::where('mail', $request->mail)->count();
            if ($count > 0) {
                Session::flash('error', 'Le mail existe déjà');
                return back();
            } else {
                try {
                    $mail = new Mails();
                    $mail->mail = $request->mail;

                    DB::beginTransaction();
                    if ($mail->save()) {

                        $services = Services::all();
                        foreach ($services as $service) {

                            $listGroup = $request->input($service->service);
                            if ($listGroup == 'on') {
                                $mail->services()->attach([
                                    'services_id' => $service->id,
                                ]);
                            }
                        }
                        DB::commit();
                        Session::flash('message', 'Le mail ' . $request->mail . ' est bien enregistré');
                        return redirect()->route("service_list_mail");
                    } else {
                        DB::rollBack();
                        Session::flash('error', 'Une erreur est survenu lors de l\'enregistrement');
                        return back();
                    }

                } catch (\Exception $e) {
                    DB::rollBack();
                    Session::flash('error', 'Une erreur est survenu lors de l\'enregistrement' . $e->getMessage());
                    Log::error('Une erreur est survenu lors de l\'enregistrement: ' . $e->getMessage());
                    return redirect()->route("service_list_mail");
                }
            }
        }
    }

    public
    function editMail(Mails $mail)
    {
        $services = Services::all();
        $mail_services = $mail->services()->pluck("services_id");
        return view("ConfigModule::mail.edit_mail", compact("mail", "services", "mail_services"));
    }

    public
    function editMailSubmit(Request $request)
    {

        $mail = Mails::where("mail", $request->hide)->first();


        $validator = Validator::make($request->all(), [
            'mail' => 'required|max:60|email',
        ]);
        if ($validator->fails()) {
            return back()
                ->withInput(request()->all())
                ->withErrors($validator);
        } else {
            try {
                $count = Mails::where('mail', $request->mail)->count();
                if ($count > 0 and $request->hide != $request->mail) {

                    Session::flash('error', 'Le mail existe déjà');
                    return back();
                } else {

                    $mail->services()->detach();
                    $services = Services::all();

                    foreach ($services as $service) {

                        $listGroup = $request->input($service->service);
                        if ($listGroup == 'on') {
                            $mail->services()->attach([
                                'services_id' => $service->id,
                            ]);
                        }
                    }

                    Mails::where('mail', $request->hide)->update(["mail" => $request->mail]);

                    Session::flash('message', 'Le mail ' . $request->mail . ' est bien enregistré');
                    return redirect()->route("service_list_mail");
                }
            } catch (\Exception $e) {
                Session::flash('error', 'Une erreur est survenu lors de l\'enregistrement' . $e->getMessage());
                Log::error('Une erreur est survenu lors de l\'enregistrement: ' . $e->getMessage());
                return redirect()->route("service_list_mail");
            }
        }
    }

    public
    function serviceModaleMail(Mails $mail)
    {
        return view("ConfigModule::mail.modale", compact("mail"));
    }

    public
    function serviceDeleteMailSubmit(Mails $mail)
    {
        if (!$mail->delete()) {
            Session::flash('error', 'Une erreur est survenue lors de la suppression du mail: ' . $mail->mail);
            Log::error('Une erreur est survenu lors de la suppression du mail: ' . $mail->mail);
        } else {
            Session::flash('message', 'Suppression réussie du mail: ' . $mail->mail);
        }
        return redirect()->route("service_list_mail");
    }
}
