<?php
namespace Bloom\Cms\Notification\Http\Controllers;

use App\Http\Controllers\Controller;
use Bloom\Cms\Notification\Data\Services;
use Bloom\Cms\Notification\Facade\Notification;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Validator;

class ServicesController extends Controller
{
    public function servicesList()
    {
        $services = Services::all();
        return view("ConfigModule::services.list_services", compact("services"));
    }

    public function serviceCreate()
    {
        return view("ConfigModule::services.edit_service");

    }

    public function serviceEdit(Services $service)
    {
        return view("ConfigModule::services.edit_service", compact("service"));
    }

    public function serviceUpdateSubmit(Request $request, Services $service)
    {
        $validator = Validator::make($request->all(), [
            'service' => 'required|max:60',
        ]);
        if ($validator->fails()) {
            return back()
                ->withInput(request()->all())
                ->withErrors($validator);
        } else {
            try {
                $count = Services::where('service', $request->service)->count();
                if ($count > 0) {
                    Session::flash('error', 'Le service existe déjà');
                    return back();
                } else {
                    Services::where("id", $service->id)->update(["service" => $request->service]);
                    Session::flash('message', 'Le groupe ' . $request->service . ' est bien enregistré');
                    return redirect()->route("services_list");
                }
            } catch (\Exception $e) {
                Session::flash('error', 'Une erreur est survenu lors de l\'enregistrement');
                Log::error('Une erreur est survenu lors de l\'enregistrement: ' . $e->getMessage());
                return redirect()->route("services_list");
            }
        }
    }

    public function serviceCreateSubmit(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'service' => 'required|max:60',
        ]);
        if ($validator->fails()) {
            return back()
                ->withInput(request()->all())
                ->withErrors($validator);
        } else {
            try {
                $count = Services::where('service', $request->service)->count();
                if ($count > 0) {
                    Session::flash('error', 'Le service existe déjà');
                    return back();
                } else {
                    $service = new Services();
                    $service->service = $request->service;
                    $service->save();
                    Session::flash('message', 'Le groupe ' . $request->service . ' est bien enregistré');
                    return redirect()->route("services_list");
                }
            } catch (\Exception $e) {
                Session::flash('error', 'Une erreur est survenu lors de l\'enregistrement' . $e->getMessage());
                Log::error('Une erreur est survenu lors de l\'enregistrement: ' . $e->getMessage());
                return redirect()->route("services_list");
            }

        }
    }

    public function serviceModale(Services $service)
    {

        return view("ConfigModule::services.modale", compact("service"));
    }
    public function serviceDeleteSubmit(Services $service){
        if (!$service->delete()) {
            Session::flash('error', 'Une erreur est survenue lors de la suppression du service: '.$service->service);
            Log::error('Une erreur est survenu lors de la suppression du service: '.$service->service);
        } else {
            Session::flash('message', 'Suppression réussie du service: '.$service->service);
        }
        return redirect()->route("services_list");
    }
}
