<?php

namespace Bloom\Cms\Notification;

use Bloom\Cms\Notification\Facade\ConfigurationsFacade;
use Bloom\Cms\Notification\Twig\Variables;
use Bloom\Cms\Notification\Commands\InitProjects;
use Bloom\CMS\Modules\Architecture\Model\AdminMenu;
use Bloom\CMS\Modules\Architecture\Model\Module;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\ServiceProvider;
use Illuminate\Support\Facades\Route;

class CmsNotificationProvider extends ServiceProvider
{
    /**
     * Register services.
     *
     */
    public function register()
    {
        if ($this->app->runningInConsole()) {
            $this->commands([InitProjects::class]);
        }
        Route::group([
            'middleware' => ['web','auth'],
            'prefix'     => config('app.admin'),
            'namespace'  => 'Bloom\Cms\Notification\Http\Controllers'],
            function () {
                Route::group(['prefix' => 'service'], function () {
                    Route::get('/edit/{service}', 'ServicesController@serviceEdit')->name('service_edit');
                    Route::post('/update/submit/{service}', 'ServicesController@serviceUpdateSubmit')->name('service_update_submit');
                    Route::post('/create/submit', 'ServicesController@serviceCreateSubmit')->name('service_create_submit');
                    Route::get('/create', 'ServicesController@serviceCreate')->name('service_create');
                    Route::get('/modale/{service}', 'ServicesController@serviceModale')->name('service_modale_get');
                    Route::get('/delete/submit/{service}', 'ServicesController@serviceDeleteSubmit')->name('service_delete_submit');
                    Route::get('/list/mail', 'ServicesMailController@listMail')->name('service_list_mail');
                    Route::get('/create/mail', 'ServicesMailController@createMail')->name('service_create_mail');
                    Route::post('/create/mail/submit', 'ServicesMailController@createMailSubmit')->name('service_mail_create_submit');
                    Route::get('/edit/mail/{mail}', 'ServicesMailController@editMail')->name('service_edit_mail');
                    Route::post('/update/mail/submit', 'ServicesMailController@editMailSubmit')->name('service_mail_update_submit');
                    Route::get('/mail/modale/{mail}', 'ServicesMailController@serviceModaleMail')->name('mail_modale_get');
                    Route::get('/delete/mail/{mail}', 'ServicesMailController@serviceDeleteMailSubmit')->name('service_mail_delete_submit');
                    Route::get('/list_service', 'ServicesController@servicesList')->name('services_list');
                });
            }
        );
        $this->loadViewsFrom(dirname(__DIR__) . '/ressources/views', 'ConfigModule');
        $this->loadMigrationsFrom(dirname(__DIR__) . '/database/migrations');
        $this->publishes([
            dirname(__DIR__) . '/ressources/mix' => public_path('/vendor/cms-module-notification'),
        ], 'assets');
        $this->publishes([
            __DIR__.'/ressources/lang/fr' => resource_path('ressources/lang/fr'),
        ],"lang");
        if (Schema::hasTable('conf_services')) {
            $this->app->singleton('notification', function () {
                return new ConfigurationsFacade();
            });
        }

    }

    public static function getModule()
    {
        if (Schema::hasTable('modules')) {
            $module = Module::nom('mails')->firstOrCreate([
                'nom'        => 'mails',
                'nom_public' => 'Mails',
                'route'      => 'service_list_mail',
            ]);
            if (!$module->exists) {
                $module->active = 1;
                $module->save();
            }
            AdminMenu::firstOrCreate([
                'module_id' => $module->id,
                'label'     => 'Services',
                'route'     => 'services_list',
                'active'    => 1,
            ]);

            return $module;
        }

        return false;
    }

    /**
     * Bootstrap services.
     * @return void
     */
    public function boot()
    {
        self::getModule();
    }
}
