let form;
window.publishAndSubmit = () => {
    form = $('.main form');
    // Si le form est pas présent c'est que jean michel click avant la fin du chargement de la page
    if (form === undefined) {
        document.addEventListener('readystatechange', publishAndSubmit);
    }

    let statut = form.find('input[name="statut_id"]').first();

    if (statut.length) {
        statut.val('1');
    } else {
        form.append($('<input name="statut_id" value="1" type="hidden">'));
    }

    form.submit();
}

document.addEventListener("readystatechange", () => {
    /**
     * Block / Unblock link_choice
     * @param {string} state
     */

    function lienChange(state) {
        function toggleLien(state) {
            $('[name="link_choice"]').prop("checked", false).prop('disabled', state);
            $('[name="page_id"]').prop("disabled", state);
            $('[name="href"]').prop("disabled", state);
        }

        function toggleForm(state) {
            $('[name="form_id"]').prop('disabled', state);
        }

        toggleLien(state !== 'lien');
        toggleForm(state !== 'form');

        $('[name="link_choice"]').each(function () {
            let $el = $(this);
            switch ($el.val()) {
                case 'interne':
                    $('#page_id').prop('disabled', !$el.is(':checked'));
                    break;
                case 'externe':
                    $('#href').prop('disabled', !$el.is(':checked'));
            }
        });
    }

    form = $('.main form');
    let lien = $('input[name="lien"]');

    if (lien.length) {
        lien.change(function (e) {
            lienChange($(e.target).val())
        });

        lienChange(lien.val());

        $('[name="link_choice"]').change(function (e) {
            let choice = e.currentTarget.value;

            if (choice.toLowerCase() == 'interne') {
                $('[name="page_id"]').prop('disabled', false);
                $('[name="href"]').prop('disabled', true);
                $('[name="href"]').val('');
            }

            if (choice.toLowerCase() == 'externe') {
                $('[name="page_id"]').prop('disabled', true);
                $('[name="page_id"]').val('');
                $('[name="href"]').prop('disabled', false);
            }
        });
    }
});