<?php
/**
 * Created by : loic
 * Created at : 21/04/2020
 *
 * In : IntelliJ IDEA
 */

namespace Bloom\CMS\Modules\Menu;

use Bloom\CMS\Core\BloomProvider;
use Bloom\CMS\Core\Framework\Admin\AdminMenu;
use Bloom\CMS\Core\Http\Events\PageStatutChange;
use Bloom\CMS\Modules\Menu\Handler\PageHandler;
use Bloom\CMS\Modules\Menu\Http\Events\Subscriber\MenuSubscriber;
use Bloom\CMS\Modules\Menu\Model\Menu;
use Illuminate\Database\Eloquent\Collection;
use Illuminate\Support\Facades\Event;
use Twig\Extension\AbstractExtension;
use Twig\Extension\GlobalsInterface;
use Twig\TwigFunction;
use Twig\TwigTest;
use TwigBridge\Facade\Twig;
use Bloom\Cms\Sites\Helpers\SiteHelper;

class CmsMenuServiceProvider extends BloomProvider
{
    protected $nom = "Menu";
    protected $code = "menu";
    protected $has_admin = true;
    protected $icons = "menu";

    public function register()
    {
        parent::register();
        Event::subscribe(MenuSubscriber::class);
        Event::listen(PageStatutChange::class, PageHandler::class.'@statutChanged');
    }

    public function boot(): void
    {
        parent::boot();
        $this->addSubMenus([
            new AdminMenu([
                'label' => 'Principal',
                'route' => 'admin_menu_index',
            ]),
            new AdminMenu([
                'label' => 'Footer',
                'route' => 'admin_menu_footer',
            ]),
            new AdminMenu([
                'label' => 'Social',
                'route' => 'admin_menu_social',
            ]),
            new AdminMenu([
                'label' => 'Sticky',
                'route' => 'admin_menu_sticky',
            ]),
        ]);

        $this->publishes([
            dirname(__DIR__) . '/public/build' => public_path('/vendor/cms-module-menu')
        ], 'assets');

//        Twig::addExtension(new class extends AbstractExtension implements GlobalsInterface {
//
//            public function getTests()
//            {
//                return [
//                    new TwigTest('onPage', function (Menu $menu) {
//                        return $menu->type !== Menu::STICKY;
//                    })
//                ];
//            }
//
//            public function getFunctions()
//            {
//                return [
//                    new TwigFunction('menu', function ($type): Collection {
//                        return Menu::type($type)->published()->get();
//                    })
//                ];
//            }
//
//
//            /**
//             * @inheritDoc
//             */
//            public function getGlobals(): array
//            {
//                return [
//                    'menu_principal' => Menu::getSiteFiltered(Menu::MAIN),
//                    'menu_social'    => Menu::getSiteFiltered(Menu::SOCIAL),
//                    'menu_sticky'    => Menu::getSiteFiltered(Menu::STICKY),
//                    'menu_footer'    => Menu::getSiteFiltered(Menu::FOOTER),
//                ];
//            }
//        });

        $configPath = __DIR__ . '/../config/menu.php';
        $this->publishes([$configPath => config_path('menu.php'),
            $configPath => config_path('menu.php')
        ], 'cms-module-menu');
    }
}
