@extends('bloom.layout.admin')

@php
    use \Carbon\Carbon;
@endphp

@section('bodyClass', 'page-listing page-menu-' . $type)

@section('assets')
    @vite('resources/js/listing.js', 'vendor/cms-module-menu')
@endsection

@section('content')
    <div class="container-fluid">
        <div id="navbar-btns" class="mb-5 heading-text d-flex justify-content-between align-items-center sticky-top">
            <div class="wrapper-titre">
                <h1>Menu</h1>
                {{-- <h2>{{ $type === 'main' ? 'Principal' : $type|title }}</h2>--}}
                <h2>{{ $type === 'main' ? 'Principal' : $type }}</h2>
            </div>

            <a href="{{ route("admin_menu_edit") }}?type={{ $type }}" class="btn btn-grisclair5 btn-primary">
                Ajouter une rubrique
            </a>
        </div>

        <div class="content" id="menu-listing">
            <div class="nav-menus" data-ordre-url="{{ route('admin_menu_reorder') }}"
                 data-limit='@json(config('$menu->limit.' . $type, ["max" => 99999]))'>
                <div class="section-archi entete">
                    <div class="pr-0 id-archi">Id</div>
                    <div class="pr-0 titre-archi col">Libellé</div>
                    <div class="pr-0 cible-archi">Page cible</div>
                    <div class="pr-0 created-archi">Créé le</div>
                    <div class="pr-0 modify-archi">Modifié le</div>
                    <div class="pr-0 actif-archi">Actif</div>
                    <div class="pr-0 btn-cta-archi"></div>
                </div>

                @foreach($menus as $menu)
                    <div class="nav-archi-primary sortable-section">
                        <div class="section-archi section-primary">
                            <div class="id-archi">{{ $menu->id }}</div>
                            <div class="titre-archi col">
                                <span class="sortable-el"></span>
                                <span class="text">{{ $menu->label }}</span>
                            </div>
                            <div class="cible-archi">
                                @if($menu->break || $type === "main" || $type === "footer")
                                    -
                                @else
                                    @if($menu->redirection_on)
                                        <strong><span class="bloomicon-admin-alert-triangle"
                                                      aria-hidden="true"></span>&nbsp;301</strong>
                                    @elseif($menu->page)
                                        <span class="tooltip-elmt d-inline-block" data-toggle="tooltip"
                                              data-placement="bottom"
                                              title="{{ $menu->page->titre }}"
                                              data-original-title="{{ $menu->page->titre }}"
                                        >
                                          {{ $menu->page_type }}
                                        </span>
                                    @else
                                        Lien externe
                                    @endif
                                @endif
                            </div>
                            <div class="created-archi">
                                <span class="tooltip-elmt d-inline-block" data-toggle="tooltip"
                                      data-placement="bottom" title="{{ $menu->cree_par->name }}">
                                    {{ Carbon::parse($menu->created_at)->format('d/m/Y') }}
                                </span>
                            </div>
                            <div class="modify-archi">
                                <span class="tooltip-elmt d-inline-block" data-toggle="tooltip"
                                      data-placement="bottom" title="{{ $menu->deriere_modification_par->name }}">
                                    {{ Carbon::parse($menu->updated_at)->format('d/m/Y') }}
                                </span>
                            </div>
                            <div class="actif-archi @if($menu->redirection_on) disabled @endif">
                                <x-forms.input-custom-switch
                                        name="actif"
                                        :id="'actif-' . $menu->id"
                                        :checked="$menu->statut_id === 1"
                                        :url="route('admin_menu_togglePublish', $menu)"
                                />
                            </div>
                            <div class="btn-cta-archi">
                                <div class="btn-group-cta btn-group-sm text-right">
                                    @if($menu->can_have_child)
                                        <a href="{{ route('admin_menu_edit') }}?parent_id={{ $menu->id }}&type={{ $type }}"
                                           class="btn btn-cta btn-orange mr-1">
                                            Ajouter une sous-rubrique
                                        </a>
                                    @endif
                                    <a href="{{ route('admin_menu_edit', $menu) }}"
                                       class="btn btn-cta btn-grisclair5 mr-1">
                                        Modifier
                                    </a>
                                    @if($type === "social" || $type === "sticky")
                                        <a href="{{ route('admin_menu_delete', $menu) }}"
                                           class="btn btn-cta btn-grisclair5 mr-1">
                                            Supprimer
                                        </a>
                                        <a
                                                {{--                                            href="{{ $menu->href ? $menu->href : $menu->page->pathname }}"--}}
                                                class="btn btn-cta btn-grisclair5 mr-1">
                                            Consulter
                                        </a>
                                    @else
                                        <div class="btn-group dropleft">
                                            <button type="button" class="dropdown-dots dropdown-toggle"
                                                    id="dropdownMenu-{{ $menu->id }}"
                                                    data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                                <span class="bloomicon-admin-more-vertical" aria-hidden="true"></span>
                                            </button>
                                            <div class="dropdown-menu" aria-labelledby="dropdownMenu{{ $menu->id }}">
                                                <a class="dropdown-item dropdown-elmt"
                                                   href="{{ route('admin_menu_delete', $menu) }}">
                                                    <span class="bloomicon-admin-trash-2" aria-hidden="true"></span>
                                                    <span class="text text-white">Supprimer</span>
                                                </a>
                                                <a class="dropdown-item dropdown-elmt"
                                                   href="{{ isset($menu['href']) ? $menu['href'] : (isset($menu->page) ? $menu->page->pathname : $menu->pathname) }}"
                                                   target="_blank">
                                                    <span class="bloomicon-admin-eye" aria-hidden="true"></span>
                                                    <span class="text text-white">Consulter</span>
                                                </a>
                                                <a class="dropdown-item dropdown-elmt"
                                                   href="{{ route('admin_menu_separate', $menu) }}">
                                                    <span class="bloomicon-admin-separation" aria-hidden="true"></span>
                                                    <span class="text text-white">Ajouter un séparateur</span>
                                                </a>
                                            </div>
                                        </div>
                                    @endif
                                </div>
                            </div>
                        </div>


                        @if(count($menu->child) > 0)
                            @foreach($menu->child as $child)
                                <div class="nav-archi-secondary sortable-section">
                                    @if($type === 'main' && $child->break)
                                        <div class="section-archi section-sep">
                                            <div class="id-archi">{{ $child->id }}</div>
                                            <div class="titre-archi col">
                                                <span class="sortable-el"></span>
                                                <span class="text">Séparateur</span>
                                            </div>
                                            <div class="btn-cta-archi d-flex align-items-center justify-content-end">
                                                <div class="btn-group-cta btn-group-sm text-right">
                                                    <a href="{{ route('admin_menu_delete', $child) }}" class="btn-rond">
                                                        <span class="bloomicon-admin-trash-2" aria-hidden="true"></span>
                                                    </a>
                                                </div>
                                            </div>
                                        </div>
                                    @else
                                        <div class="section-archi section-secondary{{ $loop->last ? ' last' : '' }}">
                                            <div class="id-archi">{{ $child->id }}</div>
                                            <div class="titre-archi col">
                                                <span class="sortable-el"></span>
                                                <span class="text">{{ $child->label }}</span>
                                            </div>
                                            <div class="cible-archi">
                                                @if(!isset($child->page) && $child->href === '')
                                                    -
                                                @else
                                                    @if($child->redirection_on)
                                                        <strong><span class="bloomicon-admin-alert-triangle"
                                                                      aria-hidden="true"></span>&nbsp;301</strong>
                                                    @elseif(isset($child->page))
                                                        <span class="tooltip-elmt d-inline-block" data-toggle="tooltip"
                                                              data-placement="bottom"
                                                              title="{{ $child->page->titre }}"
                                                              data-original-title="{{ $child->page->titre }}"
                                                        >
                                                            {{ $child->page_type }}
                                                        </span>
                                                    @else
                                                        Lien externe
                                                    @endif
                                                @endif
                                            </div>
                                            <div class="created-archi">
                                                <span class="tooltip-elmt d-inline-block" data-toggle="tooltip"
                                                      data-placement="bottom" title="{{ $child->cree_par->name }}">
                                                {{ Carbon::parse($child->created_at)->format('d/m/Y') }}
                                                </span>
                                            </div>
                                            <div class="modify-archi">
                                                <span class="tooltip-elmt d-inline-block" data-toggle="tooltip"
                                                      data-placement="bottom"
                                                      title="{{ $child->deriere_modification_par->name }}">
                                                {{ Carbon::parse($child->updated_at)->format('d/m/Y') }}
                                                </span>
                                            </div>
                                            <div class="actif-archi @if($child->redirection_on) disabled @endif">
                                                <x-forms.input-custom-switch
                                                        name="actif"
                                                        :id="'actif-' . $menu->id"
                                                        :checked="$menu->statut_id === 1"
                                                        :url="route('admin_menu_togglePublish', $menu)"
                                                />
                                            </div>
                                            <div class="btn-cta-archi">
                                                <div class="btn-group-cta btn-group-sm text-right">
                                                    @if($child->can_have_child)
                                                        <a href="{{ route('admin_menu_edit') }}?parent_id={{ $child->id }}&type={{ $type }}"
                                                           class="btn btn-cta btn-orange mr-1">
                                                            Ajouter une sous-rubrique
                                                        </a>
                                                    @endif
                                                    <a href="{{ route('admin_menu_edit', $child) }}"
                                                       class="btn btn-cta btn-grisclair5 mr-1">
                                                        Modifier
                                                    </a>

                                                    <div class="btn-group dropleft">
                                                        <button type="button" class="dropdown-dots dropdown-toggle"
                                                                id="dropdownMenu-{{ $child->id }}"
                                                                data-toggle="dropdown" aria-haspopup="true"
                                                                aria-expanded="false">
                                                            <span class="bloomicon-admin-more-vertical"
                                                                  aria-hidden="true"></span>
                                                        </button>
                                                        <div class="dropdown-menu"
                                                             aria-labelledby="dropdownMenu{{ $child->id }}">
                                                            <a class="dropdown-item dropdown-elmt"
                                                               href="{{ route('admin_menu_delete', $child) }}">
                                                                <span class="bloomicon-admin-trash-2"
                                                                      aria-hidden="true"></span>
                                                                <span class="text text-white">Supprimer</span>
                                                            </a>

                                                            <a class="dropdown-item dropdown-elmt"
                                                               href="{{ isset($child->href) ? $child->href : (isset($child->page) ? $child->page->pathname : $child->pathname) }}"
                                                               target="_blank"
                                                            >
                                                                <span class="bloomicon-admin-eye"
                                                                      aria-hidden="true"></span>
                                                                <span class="text text-white">Consulter</span>
                                                            </a>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>

                                        @if(count($child->child) > 0)
                                            @foreach($child->child as $sub)
                                                <div class="nav-archi-tertiary sortable-section">
                                                    <div
                                                            class="section-archi section-tertiary{{ $loop->last ? ' last' : '' }}">
                                                        <div class="id-archi">{{ $sub->id }}</div>
                                                        <div class="titre-archi col">
                                                            <span class="sortable-el"></span>
                                                            <span class="text">{{ $sub->label }}</span>
                                                        </div>
                                                        <div class="cible-archi">
                                                            @if(!isset($sub->page) && $sub->href === '')
                                                                -
                                                            @else
                                                                @if($sub->redirection_on)
                                                                    <strong><span class="bloomicon-admin-alert-triangle"
                                                                                  aria-hidden="true"></span>&nbsp;301</strong>
                                                                @elseif(isset($sub->page))
                                                                    <span class="tooltip-elmt d-inline-block"
                                                                          data-toggle="tooltip"
                                                                          data-placement="bottom"
                                                                          title="{{ $sub->page->titre }}"
                                                                          data-original-title="{{ $sub->page->titre }}"
                                                                    >
                                                                        {{ $sub->page_type }}
                                                                    </span>
                                                                @else
                                                                    Lien externe
                                                                @endif
                                                            @endif
                                                        </div>
                                                        <div class="created-archi">
                                                            <span class="tooltip-elmt d-inline-block"
                                                                  data-toggle="tooltip"
                                                                  data-placement="bottom"
                                                                  title="{{ $sub->cree_par->name }}">
                                                            {{ Carbon::parse($sub->created_at)->format('d/m/Y') }}
                                                            </span>
                                                        </div>
                                                        <div class="modify-archi">
                                                            <span class="tooltip-elmt d-inline-block"
                                                                  data-toggle="tooltip"
                                                                  data-placement="bottom"
                                                                  title="{{ $sub->deriere_modification_par->name }}">
                                                            {{ Carbon::parse($sub->updated_at)->format('d/m/Y') }}
                                                            </span>
                                                        </div>
                                                        <div
                                                                class="actif-archi @if($sub->redirection_on) disabled @endif">
                                                            <x-forms.input-custom-switch
                                                                    name="actif"
                                                                    :id="'actif-' . $sub->id"
                                                                    :checked="$sub->statut_id === 1"
                                                                    :url="route('admin_menu_togglePublish', $sub)"
                                                            />
                                                        </div>
                                                        <div class="btn-cta-archi">
                                                            <div class="btn-group-cta btn-group-sm text-right">
                                                                @if($sub->can_have_child)
                                                                    <a href="{{ route('admin_menu_edit') }}?parent_id={{ $sub->id }}&type={{ $type }}"
                                                                       class="btn btn-cta btn-orange mr-1">
                                                                        Ajouter une sous-rubrique
                                                                    </a>
                                                                @endif
                                                                <a href="{{ route('admin_menu_edit', $sub) }}"
                                                                   class="btn btn-cta btn-grisclair5 mr-1">
                                                                    Modifier
                                                                </a>

                                                                <div class="btn-group dropleft">
                                                                    <button type="button"
                                                                            class="dropdown-dots dropdown-toggle"
                                                                            id="dropdownMenu-{{ $sub->id }}"
                                                                            data-toggle="dropdown" aria-haspopup="true"
                                                                            aria-expanded="false">
                                                                        <span class="bloomicon-admin-more-vertical"
                                                                              aria-hidden="true"></span>
                                                                    </button>
                                                                    <div class="dropdown-menu"
                                                                         aria-labelledby="dropdownMenu{{ $sub->id }}">
                                                                        <a class="dropdown-item dropdown-elmt"
                                                                           href="{{ route('admin_menu_delete', $sub) }}">
                                                                    <span class="bloomicon-admin-trash-2"
                                                                          aria-hidden="true"></span>
                                                                            <span
                                                                                    class="text text-white">Supprimer</span>
                                                                        </a>
                                                                        <a class="dropdown-item dropdown-elmt"
                                                                           href="{{ isset($sub->href) ? $sub->href : (isset($sub->page) ? $sub->page->pathname : $sub->pathname) }}"
                                                                           target="_blank"
                                                                        >
                                                                    <span class="bloomicon-admin-eye"
                                                                          aria-hidden="true"></span>
                                                                            <span
                                                                                    class="text text-white">Consulter</span>
                                                                        </a>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>

                                                    @if(count($sub->child) > 0)
                                                        @foreach($sub->child as $southsub)
                                                            <div class="nav-archi-quaternary sortable-section">
                                                                <div
                                                                        class="section-archi section-quaternary{{ $loop->last ? ' last' : '' }}">
                                                                    <div class="id-archi">{{ $southsub->id }}</div>
                                                                    <div class="titre-archi col">
                                                                        <span class="sortable-el"></span>
                                                                        <span class="text">{{ $southsub->label }}</span>
                                                                    </div>
                                                                    <div class="cible-archi">
                                                                        @if(!isset($southsub->page) && $southsub->href === '')
                                                                            -
                                                                        @else
                                                                            @if($southsub->redirection_on)
                                                                                <strong>
                                                                        <span class="bloomicon-admin-alert-triangle"
                                                                              aria-hidden="true"></span>&nbsp;
                                                                                    301
                                                                                </strong>
                                                                            @elseif(isset($southsub->page))
                                                                                <span
                                                                                        class="tooltip-elmt d-inline-block"
                                                                                        data-toggle="tooltip"
                                                                                        data-placement="bottom"
                                                                                        title="{{ $southsub->page->titre }}"
                                                                                        data-original-title="{{ $southsub->page->titre }}"
                                                                                >
                                                                                    {{ $southsub->page_type }}
                                                                                </span>
                                                                            @else
                                                                                Lien externe
                                                                            @endif
                                                                        @endif
                                                                    </div>
                                                                    <div class="created-archi">
                                                                        <span class="tooltip-elmt d-inline-block"
                                                                              data-toggle="tooltip"
                                                                              data-placement="bottom"
                                                                              title="{{ $southsub->cree_par->name }}">
                                                                        {{ Carbon::parse($southsub->created_at)->format('d/m/Y') }}
                                                                        </span>
                                                                    </div>
                                                                    <div class="modify-archi">
                                                                        <span class="tooltip-elmt d-inline-block"
                                                                              data-toggle="tooltip"
                                                                              data-placement="bottom"
                                                                              title="{{ $southsub->deriere_modification_par->name }}">
                                                                        {{ Carbon::parse($southsub->updated_at)->format('d/m/Y') }}
                                                                        </span>
                                                                    </div>
                                                                    <div
                                                                            class="actif-archi @if($southsub->redirection_on) disabled @endif">
                                                                        <x-forms.input-custom-switch
                                                                                name="actif"
                                                                                :id="'actif-' . $southsub->id"
                                                                                :checked="$southsub->statut_id === 1"
                                                                                :url="route('admin_menu_togglePublish', $southsub)"
                                                                        />
                                                                    </div>
                                                                    <div class="btn-cta-archi">
                                                                        <div
                                                                                class="btn-group-cta btn-group-sm text-right">
                                                                            <a href="{{ route('admin_menu_edit', $southsub) }}"
                                                                               class="btn btn-cta btn-grisclair5 mr-1">
                                                                                Modifier
                                                                            </a>

                                                                            <div class="btn-group dropleft">
                                                                                <button type="button"
                                                                                        class="dropdown-dots dropdown-toggle"
                                                                                        id="dropdownMenu-{{ $southsub->id }}"
                                                                                        data-toggle="dropdown"
                                                                                        aria-haspopup="true"
                                                                                        aria-expanded="false">
                                                                                    <span
                                                                                            class="bloomicon-admin-more-vertical"
                                                                                            aria-hidden="true"></span>
                                                                                </button>
                                                                                <div class="dropdown-menu"
                                                                                     aria-labelledby="dropdownMenu{{ $southsub->id }}">
                                                                                    <a class="dropdown-item dropdown-elmt"
                                                                                       href="{{ route('admin_menu_delete', $southsub) }}">
                                                                                        <span
                                                                                                class="bloomicon-admin-trash-2"
                                                                                                aria-hidden="true"></span>
                                                                                        <span class="text text-white">Supprimer</span>
                                                                                    </a>
                                                                                    <a class="dropdown-item dropdown-elmt"
                                                                                       href="{{ isset($southsub->href) ? $southsub->href : (isset($southsub->page) ? $southsub->page->pathname : $southsub->pathname) }}"
                                                                                       target="_blank"
                                                                                    >
                                                                                        <span
                                                                                                class="bloomicon-admin-eye"
                                                                                                aria-hidden="true"></span>
                                                                                        <span class="text text-white">Consulter</span>
                                                                                    </a>
                                                                                </div>
                                                                            </div>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        @endforeach
                                                    @endif

                                                </div>
                                            @endforeach
                                        @endif

                                    @endif
                                </div>
                            @endforeach
                        @endif
                    </div>
                @endforeach
            </div>
        </div>
    </div>
@endsection