<?php
/**
 * Created by : loic
 * Created at : 21/04/2020
 *
 * In : IntelliJ IDEA
 */

namespace Bloom\CMS\Modules\Menu\Http\Controllers;


use Bloom\CMS\Modules\Architecture\Model\Page;
use Bloom\CMS\Modules\Architecture\Model\Statut;
use Bloom\CMS\Modules\Menu\Model\Menu;
use Bloom\CMS\Modules\Menu\Model\StickIn;
use Illuminate\Database\Eloquent\Relations\Relation;
use Illuminate\Routing\Controller;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Str;


class AdminController extends Controller
{
    public function listing(string $type = Menu::MAIN)
    {
        return view(
            'Menu::admin.listing',
            [
                'menus' => Menu::query()
                    ->where('type', '=', $type)
                    ->whereNull('parent_id')
                    ->whereIn('statut_id', [Statut::PUBLIE, Statut::EN_COURS])
                    ->get(),
                'type'  => $type
            ]
        );
    }


    public function index()
    {
        return $this->listing();
    }

    public function footer()
    {
        return $this->listing(Menu::FOOTER);
    }

    public function sticky()
    {
        return $this->listing(Menu::STICKY);
    }

    public function social()
    {
        return $this->listing(Menu::SOCIAL);
    }

    public function edit(Menu $menu)
    {
        $pages = Page::published()->get();

        if (!$menu->exists && request()->has('parent_id')) {
            $menu->parent_id = request('parent_id');
        }
        if (!$menu->exists && request()->has('type')) {
            $menu->type = request('type');
        }
        $parent = null;
        if ($menu->parent_id) {
            $parent = Menu::find($menu->parent_id);
        }

        if ($menu->type === Menu::STICKY) {

            $applicables = [];
            foreach (Relation::morphMap() as $name => $class) {
                $applicables[ Str::singular($name) ] = $class . ';' . Page::SINGLE;
                $applicables[ Str::plural($name) ] = $class . ';' . Page::MUTLI;
            }

            $stickIns = [];
            foreach ($menu->in as $stickIn) {
                /**
                 * @var StickIn $stickIn
                 */
                if ($stickIn->contenu_type !== '') {
                    $stickIns[] = $stickIn->contenu_type . ';' . $stickIn->multiplicity;
                }
            }

            return view('Menu::admin.edit_sticky', compact('pages', 'menu', 'applicables', 'stickIns'));
        }
        if ($menu->type === Menu::SOCIAL) {
            return view('Menu::admin.edit_social', compact('pages', 'menu'));
        }

        return view('Menu::admin.edit', compact('pages', 'menu', 'parent'));
    }

    public function save(Menu $menu)
    {
        $user_id = Auth::user()->getAuthIdentifier();

        if (request()->has('statut_id')) {
            $statut = request('statut_id');
        } else {
            $statut = $menu->statut_id ?: 2;
        }
        $menu->picto = request('picto', '');
        $menu->couleur = request('couleur', '');
        $menu->couleur_bg = request('couleur_bg', '');
        $menu->type = request('type', Menu::MAIN);

        $menu->label = request('label');
        $menu->href = request('href');
        $menu->page_id = request('page_id');

        if (!request('lien', false) && request('parent_id') !== null) {
            $menu->break = true;
        }

        $menu->statut_id = (int)$statut;
        $menu->parent_id = request('parent_id');
        if (request('link_choice') === 'externe') {
            $menu->href = request('href', '#');
        }

        if (!$menu->exists) {
            $menu->created_by = $user_id;
            if ($menu->parent) {
                $menu->ordre = $menu->parent->child->count();
            } else {
                $menu->ordre = Menu::query()->where('type', '=', $menu->type)->count();
            }
        }

        if ($menu->isDirty()) {
            // On mets à jour la page
            $menu->updated_by = $user_id;
        }


        if ($menu->type === Menu::MAIN || $menu->type === Menu::FOOTER) {
            $limit = config('menu.limit');
            if (array_key_exists($menu->type, $limit)) {
                $l = $limit[ $menu->type ];
                Log::debug('Limit check', ['limit' => $limit[ $menu->type ]]);
                if (array_key_exists($menu->parents->count(), $l)) {
                    if ($menu->statut_id == Statut::PUBLIE && $menu->isDirty('statut_id')) {
                        // On a que des limits de lvl 0 pour l'instant
                        if (Menu::published()->whereNull('parent_id')->count() >= $l[ $menu->parents->count() ]['max']) {
                            $m = Menu::published()->whereNull('parent_id')->where('id', '!=', $menu->id)->orderBy('ordre', 'desc')->first();
                            $m->statut_id = Statut::EN_COURS;
                            $m->save();
                        }
                    }
                }
            }
        }

        $menu->save();

        if ($menu->type === Menu::STICKY) {
            $dirty = false;
            $applicables = request('applicable', []);

            foreach ($applicables as $applicable => $checked) {
                list($class, $mutlitplicity) = explode(';', $applicable);
                if ($menu->in()->where('contenu_type', '=', $class)->where('multiplicity', '=', $mutlitplicity)->count() === 0) {
                    $menu->in()->create(
                        [
                            'menu_id'      => $menu->id,
                            'contenu_type' => $class,
                            'multiplicity' => $mutlitplicity
                        ]
                    );
                    $dirty = true;
                }
            }
            if (count($applicables) < $menu->in()->count()) {
                foreach ($menu->in as $stickIn) {
                    if ($stickIn->page_id !== null) continue;
                    /**
                     * @var StickIn $stickIn
                     */
                    if (!in_array($stickIn->contenu_type . ';' . $stickIn->multiplicity, $applicables)) {
                        $stickIn->delete();
                    }
                }
            }
            if ($dirty) {
                $menu->updated_by = $user_id;
                $menu->save();
            }
        }

        switch ($menu->type) {
            case Menu::SOCIAL:
                return redirect()->route('admin_menu_social');
            case Menu::STICKY:
                return redirect()->route('admin_menu_sticky');
            case Menu::FOOTER:
                return redirect()->route('admin_menu_footer');
            case Menu::MAIN:
                // no break;
            default:
                return redirect()->route('admin_menu_index');
        }
    }

    public function togglePublish(Menu $menu)
    {
        try {
            $menu->statut_id == 1 ? $this->unpublish($menu) : $this->publish($menu);

            return ['status' => true, 'error' => false];
        } catch (\Throwable $e) {
            return response(['status' => false, 'error' => $e->getMessage()]);
        }
    }


    public function publish(Menu $menu)
    {
        $menu->statut_id = Statut::PUBLIE;
        $menu->save();

        return redirect()->back();
    }

    public function unpublish(Menu $menu)
    {
        $menu->statut_id = Statut::EN_COURS;
        $menu->save();

        return redirect()->back();
    }

    public function delete(Menu $menu)
    {
        $menu->softDelete();

        return redirect()->back();
    }

    public function reorder()
    {
        $parent_id = request('parent_id');
        $ordre = request('ordre', []);
        if ($parent_id !== 'Id') {
            $collection = Menu::query()->where('parent_id', '=', $parent_id)->get();
        } else {
            $collection = Menu::query()->whereIn('id', $ordre)->get();
        }
        foreach ($collection as $menu) {
            /**
             * @var Menu $menu
             */
            $menu->ordre = array_search($menu->id, $ordre, false);
            $menu->save();
        }

        return ['status' => true, 'error' => false];
    }

}