import Sortable from "sortablejs";

document.addEventListener("readystatechange", () => {
    let url = $('.nav-menus').data('ordre-url');
    /**
     *
     * @type {Array<{lvl: number, max: number}>}
     */
    const limit = $('.nav-menus').data('limit');

    let option = {
        handle: '.sortable-el',
        animation: 150,
        onUpdate: function (event) {
            let el = $(event.from);
            let section = el.find('> .section-archi');
            let items = [];
            el.find('> .sortable-section').each(function () {
                let el = $(this);
                let section = el.find('> .section-archi');
                items.push(section.find('.id-archi').text());
            });
            axios.post(url, {ordre: items, parent_id: section.find('.id-archi').text()});
        }
    };

    new Sortable($('.nav-menus').get(0), {
            ...option,
            group: 'primary',
            draggable: '> .nav-archi-primary'
        }
    );
    $('.nav-menus').find('.nav-archi-primary').each(function () {
        if ($(this).find('.nav-archi-secondary').length > 0) {
            new Sortable(this, {
                ...option,
                group: $(this).find('.section-primary .id-archi').text(),
                draggable: '> .nav-archi-secondary'
            });
            $(this).find('.nav-archi-secondary').each(function () {
                if ($(this).find('.nav-archi-tertiary').length > 0) {
                    new Sortable(this, {
                        ...option,
                        group: $(this).find('.section-secondary .id-archi').text(),
                        draggable: '> .nav-archi-tertiary'
                    });
                    $(this).find('.nav-archi-tertiary').each(function () {
                        if ($(this).find('.nav-archi-quaternary').length > 0) {
                            new Sortable(this, {
                                ...option,
                                group: $(this).find('.section-tertiary .id-archi').text(),
                                draggable: '> .nav-archi-quaternary'
                            });
                        }
                    });
                }
            });
        }
    });

    let triggerActif = true;
    $('.nav-menus input[name="actif"]').change(function (e) {
        if (!triggerActif) {
            return;
        }
        let $input = $(this);
        let val = $input.is(':checked');
        let ajaxHandler = (number) => {
            let n = 1;
            return () => {
                triggerActif = n++ === number;
            }
        };
        $(document).off('ajaxComplete');

        // Si on dépublie
        if (!val) {
            triggerActif = false;
            // On remonte à la section
            let section = $input.parents('.sortable-section').first();
            // On force le checked sur tous les sous actifs
            let inputs =
                section.find('> .sortable-section').find('input[name="actif"]').not(this);
            if (inputs.length) {
                $(document).bind("ajaxComplete", ajaxHandler(inputs.length));
                inputs.prop('checked', false).change();
                return;
            } else {
                triggerActif = true;
            }
        }

        // On check le lvl
        let lvl = $input.parents('.sortable-section').length - 1;
        if (lvl === 0 && val) {
            // On check combien de menu principal sont publié
            let nb = $('.section-primary input[name="actif"]:checkbox:checked').length;
            if (nb > limit[0].max) {
                // On desactive le dernier menu publié
                let lastMenu = $('.section-primary input[name="actif"]:checkbox:checked').not(this).last();
                lastMenu.prop('checked', false).change();
            }
        }
    })
});