<?php
/**
 * Created by : loic
 * Created at : 21/04/2020
 *
 * In : IntelliJ IDEA
 */

namespace Bloom\CMS\Modules\Menu\Http\Controllers;

use Bloom\CMS\Core\Contenus\Applicabilite;
use Bloom\CMS\Core\Contenus\Statut;
use Bloom\CMS\Core\Http\Form;
use Bloom\CMS\Core\Http\Page;
use Bloom\CMS\Modules\Menu\Model\Menu;
use Bloom\CMS\Modules\Menu\Model\StickIn;
use Illuminate\Routing\Controller;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Event;
use Illuminate\Support\Facades\Log;
use Bloom\Cms\Sites\Repository\Eloquent\SiteRepository;

/**
 * Class AdminController
 * @package Bloom\CMS\Modules\Menu\Http\Controllers
 */
class AdminController extends Controller
{
    public function listing(string $type = Menu::MAIN)
    {
        $data = [
            'menus' => Menu::query()
                ->where('type', '=', $type)
                ->whereNull('parent_id')
                ->whereIn('statut_id', [Statut::PUBLIE, Statut::EN_COURS])
                ->get(),
            'type'  => $type
        ];

        if ($type === Menu::STICKY) {
            $data['applicables'] = Applicabilite::applicableOn(Applicabilite::STICKY)->get();
        }

        return view('Menu::admin.listing', $data);
    }


    public function index()
    {
        return $this->listing();
    }

    public function footer()
    {
        return $this->listing(Menu::FOOTER);
    }

    public function sticky()
    {
        return $this->listing(Menu::STICKY);
    }

    public function social()
    {
        return $this->listing(Menu::SOCIAL);
    }

    public function edit(Menu $menu, SiteRepository $siteRepository)
    {
        $sites = $site_menus = null;
        if (config('sites.multi_sites')) {
            $sites = $siteRepository->getEnLigne();
            $site_menus = $menu->sites()->get();
        }
        $pages = Page::published()
            ->whereNull('dossier_id')->get()
            ->merge(
                Page::published()->where('is_index', '=', 1)->get()->filter(function (Page $p) {
                    return $p->dossier->nb_parents === 0;
                })
            );

        if (!$menu->exists && request()->has('parent_id')) {
            $menu->parent_id = request('parent_id');
        }
        if (!$menu->exists && request()->has('type')) {
            $menu->type = request('type');
        }
        $parent = null;
        if ($menu->parent_id) {
            $parent = Menu::find($menu->parent_id);
        }
        if ($menu->type === Menu::STICKY || $menu->type === Menu::FOOTER) {
            $forms = Form::all();
        }

        if ($menu->type === Menu::STICKY) {
            $applicables = Applicabilite::applicableOn(Applicabilite::STICKY)->get();

            $stickIns = [];
            foreach ($menu->in as $stickIn) {
                /**
                 * @var StickIn $stickIn
                 */
                if ($stickIn->contenu_type !== '') {
                    $stickIns[] = $stickIn->contenu_type . ';' . $stickIn->multiplicity . ';' . $stickIn->page_id;
                }
            }

            /**/
            for($i = 0 ; $i < count($pages) ; $i++) {
                //if($pages[$i]->contenu_type != '') $pages[$i]->contenu_type = 'miroir';
                $pages[$i]->selectionnee = in_array($pages[$i]->contenu_type . ';1;' . $pages[$i]->id, $stickIns);
            }
            /**/

            return view('Menu::admin.edit_sticky', compact('pages', 'menu', 'applicables', 'stickIns', 'forms', 'sites', 'site_menus'));
        }
        if ($menu->type === Menu::SOCIAL) {
            return view('Menu::admin.edit_social', compact('pages', 'menu', 'sites', 'site_menus'));
        }
        if ($menu->type === Menu::FOOTER) {
            return view('Menu::admin.edit', compact('pages', 'menu', 'parent', 'forms', 'sites', 'site_menus'));
        }

        return view('Menu::admin.edit', compact('pages', 'menu', 'parent', 'sites', 'site_menus'));
    }

    public function save(Menu $menu, SiteRepository $siteRepository)
    {
        $user_id = Auth::user()->getAuthIdentifier();

        if (request()->has('statut_id')) {
            $statut = request('statut_id');
        } else {
            $statut = $menu->statut_id ?: 2;
        }
        $menu->picto = request('picto', '');
        $menu->couleur = request('couleur', '');
        $menu->couleur_bg = request('couleur_bg', '');
        $menu->type = request('type', Menu::MAIN);

        $menu->label = request('label');
        $menu->href = request('href');
        $page_id = request('page_id');
        $type = 'pages';
        if ($page_id !== null) {
            list($page_id, $type) = explode(';', $page_id);
        }
        if ($type === 'pages') {
            $menu->page_id = $page_id;
        } else {
            $menu->miroir_id = $page_id;
        }
        $menu->break = false;
        $menu->form_id = request('form_id');

        $menu->statut_id = (int)$statut;
        $menu->parent_id = request('parent_id');
        if (request('link_choice') === 'externe') {
            $menu->href = request('href', '#');
        }

        if (!$menu->exists) {
            $menu->created_by = $user_id;
            if ($menu->parent) {
                $menu->ordre = $menu->parent->child->count();
            } else {
                $menu->ordre = Menu::query()->where('type', '=', $menu->type)->count();
            }
        }

        if ($menu->isDirty()) {
            // On mets à jour la page
            $menu->updated_by = $user_id;
        }


        if ($menu->type === Menu::MAIN || $menu->type === Menu::FOOTER) {
            $limit = config('menu.limit');
            if (array_key_exists($menu->type, $limit)) {
                $l = $limit[$menu->type];
                Log::debug('Limit check', ['limit' => $limit[$menu->type]]);
                if (array_key_exists($menu->parents->count(), $l)) {
                    if ($menu->statut_id == Statut::PUBLIE && $menu->isDirty('statut_id')) {
                        // On a que des limits de lvl 0 pour l'instant
                        if (Menu::published()->whereNull('parent_id')->count() > $l[$menu->parents->count()]['max']) {
                            $m = Menu::published()->whereNull('parent_id')->where('id', '!=', $menu->id)->orderBy(
                                'ordre',
                                'desc'
                            )->first();
                            $m->statut_id = Statut::EN_COURS;
                            $m->save();
                        }
                    }
                }
            }
        }

        $menu->save();

        if ($menu->type === Menu::STICKY) {
            $dirty = false;
            $applicables = request('applicable', []);
            $pages_concernees = request('page_id_conc', []);
            $criteres = array_merge($applicables, $pages_concernees);


            // Gestion des pages et des modeles en meme temps
            for ($i = 0 ; $i < count($criteres) ; $i++) {
                $tab_datas = explode(';', $criteres[$i]);
                $class = ( $tab_datas[0] != '' ) ? $tab_datas[0] : "miroir";
                $multi = $tab_datas[1];
                if(count($tab_datas) > 2) {
                    $pid = $tab_datas[2];
                } else {
                    $criteres[$i] .= ';'; // Ajout pour pouvoir utiliser le tableau criteres pour verifier les suppressions (l.220 et suivantes)
                }

                if(isset($pid)) {
                    $nb = $menu->in()->where('page_id', '=', $pid)->count();
                } else {
                    $pid = NULL;
                    $nb = $menu->in()->where('contenu_type', '=', $class)->where('multiplicity', '=', $multi)->count();
                }
                if ($nb === 0) {
                    $menu->in()->create(
                        [
                            'page_id' => $pid,
                            'menu_id' => $menu->id,
                            'contenu_type' => $class,
                            'multiplicity' => $multi
                        ]
                    );
                    $dirty = true;
                }
            }

            foreach ($menu->in as $stickIn) {
                /**
                * @var StickIn $stickIn
                */

                if (!in_array($stickIn->contenu_type . ';' . $stickIn->multiplicity . ';' . $stickIn->page_id, $criteres)) {
                    $stickIn->delete();
                }
            }
            if ($dirty) {
                $menu->updated_by = $user_id;
                $menu->save();
            }
        }

        $menu->sites()->detach();
        $sites = $siteRepository->getEnLigne();
        foreach ($sites as $site) {
            $site_menu = request('site' . $site->id);
            if ($site_menu == 'on') {
                $menu->sites()->attach([
                    'sites_id' => $site->id,
                ]);
            }
        }
        switch ($menu->type) {
            case Menu::SOCIAL:
                return redirect()->route('admin_menu_social');
            case Menu::STICKY:
                return redirect()->route('admin_menu_sticky');
            case Menu::FOOTER:
                return redirect()->route('admin_menu_footer');
            case Menu::MAIN:
                // no break;
            default:
                return redirect()->route('admin_menu_index');
        }
    }

    public function togglePublish(Menu $menu)
    {
        $publish = 'Contenu publié avec succès';
        $unpublish = 'Contenu dépublié avec succès';

        Event::forget('eloquent.saving: ' . Menu::class);
        Event::forget('eloquent.saved: ' . Menu::class);

        try {
            if (request('value')) {
                if (request('value') == 0) {
                    $this->unpublish($menu);
                } else {
                    $this->publish($menu);
                }
            } else {
                $menu->statut_id == 1 ? $this->unpublish($menu) : $this->publish($menu);
            }

            return ['message' => $menu->statut_id == 1 ? $publish : $unpublish, 'status' => true, 'error' => false];
        } catch (\Throwable $e) {
            return response(['status' => false, 'error' => $e->getMessage()]);
        }
    }


    public function publish(Menu $menu)
    {
        $menu->statut_id = Statut::PUBLIE;
        $menu->save();

        return redirect()->back();
    }

    public function unpublish(Menu $menu)
    {
        $menu->statut_id = Statut::EN_COURS;
        $menu->save();

        return redirect()->back();
    }

    public function delete(Menu $menu)
    {
        $menu->softDelete();

        return redirect()->back();
    }

    public function reorder()
    {
        $parent_id = request('parent_id');
        $ordre = request('ordre', []);
        if ($parent_id !== 'Id') {
            $collection = Menu::query()->where('parent_id', '=', $parent_id)->get();
        } else {
            $collection = Menu::query()->whereIn('id', $ordre)->get();
        }
        foreach ($collection as $menu) {
            /**
             * @var Menu $menu
             */
            $menu->ordre = array_search($menu->id, $ordre, false);
            $menu->save();
        }

        return ['status' => true, 'error' => false];
    }

    public function addSeparation(Menu $menu)
    {
        if ($menu->type !== Menu::MAIN) {
            return redirect()->back();
        }

        $user = Auth::user();
        $separation = new Menu();
        $separation->break = true;
        $separation->label = 'Séparation';
        $separation->parent_id = $menu->id;
        $separation->picto = '';
        $separation->couleur = '';
        $separation->couleur_bg = '';
        $separation->type = Menu::MAIN;
        $separation->cree_par()->associate($user);
        $separation->deriere_modification_par()->associate($user);
        $separation->statut_id = Statut::PUBLIE;
        $separation->ordre = $menu->child()->count();
        $separation->save();

        return redirect()->back();
    }

}
