@extends('bloom.layout.admin')

@section('bodyClass', 'page-edit')

@section('assets')
    @vite('resources/js/form.js', '/vendor/cms-module-menu')
    @vite('resources/js/multisites.js', '/vendor/cms-module-menu')
    {{--<script src="{{ asset('/plugins/ckeditor/ckeditor.js') }}"></script>--}}
    {{--{{ global.ckfinder() }}--}}
@endsection

@section('content')
    <div class="container-fluid">
        <div id="navbar-btns" class="mb-5 heading-text d-flex justify-content-between align-items-center sticky-top">
            <h1>{{ isset($menu) ? 'Modifier' : 'Ajouter' }} une rubrique</h1>

            <span class="wrapper-btns ml-auto">
                @if($menu->type === 'main')
                    @php($r="admin_menu_index")
                @elseif($menu->type === 'footer')
                    @php($r="admin_menu_footer")
                @endif
                <a href="{{ route($r) }}" class="btn-annuler btn btn-grisclair5 btn-primary">
                    Annuler
                </a>
                <a href="javascript:void(0);" class="btn-valider submit btn btn-grisclair5 btn-primary"
                   onclick="$('.main form').submit()">
                    Valider
                </a>
                <a href="javascript:void(0);" class="btn-publier submit btn btn-grisclair5 btn-primary"
                   onclick="publishAndSubmit()">
                    Valider et publier
                </a>
            </span>
        </div>

        <div class="content">
            <form action=" {{ route('admin_menu_save', $menu) }} " method="POST" id="form"
                  enctype="multipart/form-data">
                <div class="form-group row mb-0">
                    <div class="col-6 mb-4">
                        {{--            {{ field.inputText("label", "Libellé", menu.label, "", 'admin') }}--}}
                        {{--          </div>--}}
                    </div>

                    @if($menu->type === "footer")
                        <div class="form-group mb-0">
                            {{--            {{ field.inputCustomSwitchRadio("lien", ['lien', 'form'], ['Lien', 'Form'], [menu.form_id is null, menu.form_id is not null], ['Lien', 'Formulaire'], true, false) }}--}}
                        </div>
                    @else
                        <div class="form-group row mb-0">
                            <div class="col-6">
                                {{--{{ field.inputCustomSwitch(--}}
                                {{--  "lien",--}}
                                {{--  'lien',--}}
                                {{--  menu.has_lien,--}}
                                {{--  '',--}}
                                {{--  'Lien',--}}
                                {{--  (parent != null and parent.parents.count() == 2) or menu.type == "footer",--}}
                                {{--not menu.can_have_lien--}}
                                {{--) }}--}}
                            </div>
                        </div>
                    @endif

                    <div class="wrapper-exergue mb-4">
                        <div class="form-group block-lien row mb-0 @if(is_null($menu->form_id)) d-none @endif">
                            <div class="col-6">
                                {{--{{ field.inputCustomRadio('link_choice', 'Interne', 'interne', 'admin', false, false, menu.page_id != null or menu.miroir_id != null) }}--}}
                                <select class="form-control" name="page_id" id="page_id">
                                    <option value=""></option>
                                    @foreach($pages as $page)
                                        {{--{{ _self.pagesOptions($menu, $page) }}--}}
                                        <x-options
                                                :menu="$menu"
                                                :page="$page"
                                        />
                                    @endforeach
                                </select>
                            </div>

                            <div class="col-6">
                                {{--{{ field.inputCustomRadio('link_choice', 'Externe', 'externe', 'admin', false, false, menu.href != '') }}--}}
                                {{--{{ field.inputText("href", '', menu.href, "", '') }}--}}
                            </div>
                        </div>

                        @if($menu->type == "footer")
                            <div class="form-group block-form row mb-0 @if(is_null($menu->form_id)) d-none @endif">
                                <div class="col-6">
                                    {{--  {{ field.inputSelect('form_id', 'Formulaire associé', menu.form_id, 'admin', false, forms, 'id', 'titre') }}--}}
                                </div>
                            </div>
                        @endif
                    </div>

                    <div class="form-group row mb-0">
                        <div class="col-6 mb-4">
                            <label for="parent_id" class="control-label">
                                Rubrique parente
                            </label>

                            <div class="wrapper-inputs">
                                <select class="form-control disabled" name="parent_id" id="parent_id" disabled>
                                    <option value="{{ $menu->parent_id }}">{{ $menu->parent->label }}</option>
                                </select>
                                <input type="hidden" name="parent_id" value="{{ $menu->parent_id }}">
                            </div>
                        </div>
                    </div>

                    @if(is_empty($sites))
                    @else
                        <div class="col-6 mb-4">
                            <label class="control-label">Liste des sites disponibles</label>
                            @if(count($sites) > 1)
                                <div class="custom-control custom-checkbox select-all-div">
                                    <input type="checkbox" name="select-all-sites" class="custom-control-input"
                                           id="select-all-sites"
                                           checked
                                    >
                                    <label class="custom-control-label" for="select-all-sites"> Tout sélectionner /
                                        désélectionner</label>
                                </div>
                            @endif
                            @foreach($sites as $site)
                                <div class="custom-control custom-checkbox">
                                    <input type="checkbox" name="site{{ $site->id }}"
                                           class="custom-control-input site-checkbox"
                                           id="site{{ $site->id }}"
                                           @if(isset($menu))
                                               @foreach($site_menus as $site_menu)
                                                   {{ $site_menu->id === $site->id?'checked':'' }}
                                               @endforeach
                                           @else
                                               checked
                                            @endif
                                    >
                                    <label class="custom-control-label"
                                           for="site{{ $site->id }}">{{ $site->domaine_public }}</label>
                                </div>
                            @endforeach
                        </div>
                    @endif
                    <input type="hidden" name="type" value="{{ $menu->type }}">

                {{ csrf_field() }}
            </form>
        </div>
    </div>
@endsection