<?php

/**
 * Created by IntelliJ IDEA.
 * User: loic
 * Date: 20/04/2021
 * Time: 12:36
 */

namespace Bloom\CMS\Modules\Menu\Handler;

use Bloom\CMS\Core\Contenus\Statut;
use Bloom\CMS\Core\Http\Events\PageStatutChange;
use Bloom\CMS\Modules\Menu\Model\Menu;

/**
 * Class PageHandler
 * @package Bloom\CMS\Modules\Menu\Handler
 */
class PageHandler
{
    public function statutChanged(PageStatutChange $statutChange)
    {
        $page = $statutChange->page;
        if ((int)$page->statut_id !== Statut::ARCHIVE) {
            // On ne traite que le cas ou la page se fait archivé
            return;
        }
        // On verifie si la page est liée a un menu
        $menus = Menu::query()->where('page_id', '=', $page->id)->get();
        if ($menus->count() > 0) {
            // La page a au moins 1 mea
            foreach ($menus as $menu) {
                $menu->statut_id = Statut::ARCHIVE;
                $menu->save();
            }
        }
    }
}
