<?php
/**
 * Created by : loic
 * Created at : 21/04/2020
 *
 * In : IntelliJ IDEA
 */

namespace Bloom\CMS\Modules\Menu\Model;

use Bloom\CMS\Core\Http\Page;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Model;

/**
 * Class Article
 * @package Bloom\CMS\Modules\Produits\Model
 *
 *
 * @property Menu   menu
 * @property integer page_id;
 * @property string contenu_type
 * @property string multiplicity
 * @property Page   page
 *
 * @method static Builder|static published()
 * @method static Builder|static archived()
 * @method static Builder|static type(string $type)
 */
class StickIn extends Model
{
    protected $guarded = [];

    protected $table = 'stick_in';


    public function menu()
    {
        return $this->belongsTo(Menu::class);
    }

    public function page()
    {
        return $this->belongsTo(Page::class);
    }
}
