<?php
/**
 * Created by : loic
 * Created at : 21/04/2020
 *
 * In : IntelliJ IDEA
 */

namespace Bloom\CMS\Modules\Menu;

use Bloom\CMS\Core\BloomProvider;
use Bloom\CMS\Core\Framework\Admin\AdminMenu;
use Bloom\CMS\Core\Http\Events\PageStatutChange;
use Bloom\CMS\Modules\Menu\Handler\PageHandler;
use Bloom\CMS\Modules\Menu\Http\Events\Subscriber\MenuSubscriber;
use Bloom\CMS\Modules\Menu\Model\Menu;
use Illuminate\Database\Eloquent\Collection;
use Illuminate\Support\Facades\Event;
use Twig\Extension\AbstractExtension;
use Twig\Extension\GlobalsInterface;
use Twig\TwigFunction;
use Twig\TwigTest;
use TwigBridge\Facade\Twig;

class CmsMenuServiceProvider extends BloomProvider
{
    protected $nom = "Menu";
    protected $code = "menu";
    protected $has_admin = true;
    protected $icons = "menu";

    public function register()
    {
        parent::register();
        Event::subscribe(MenuSubscriber::class);
        Event::listen(PageStatutChange::class, PageHandler::class.'@statutChanged');
    }

    public function boot(): void
    {
        parent::boot();
        $this->addSubMenus([
            new AdminMenu([
                'label' => 'Principal',
                'route' => 'admin_menu_index',
            ]),
            new AdminMenu([
                'label' => 'Footer',
                'route' => 'admin_menu_footer',
            ]),
            new AdminMenu([
                'label' => 'Social',
                'route' => 'admin_menu_social',
            ]),
            new AdminMenu([
                'label' => 'Sticky',
                'route' => 'admin_menu_sticky',
            ]),
        ]);

        Twig::addExtension(new class extends AbstractExtension implements GlobalsInterface {

            public function getTests()
            {
                return [
                    new TwigTest('onPage', function (Menu $menu) {
                        return $menu->type !== Menu::STICKY;
                    })
                ];
            }

            public function getFunctions()
            {
                return [
                    new TwigFunction('menu', function ($type): Collection {
                        return Menu::type($type)->published()->get();
                    })
                ];
            }


            /**
             * @inheritDoc
             */
            public function getGlobals()
            {
                return [
                    'menu_principal' => Menu::type(Menu::MAIN)->published()->get(),
                    'menu_social'    => Menu::type(Menu::SOCIAL)->published()->get(),
                    'menu_sticky'    => Menu::type(Menu::STICKY)->published()->get(),
                    'menu_footer'    => Menu::type(Menu::FOOTER)->published()->get(),
                ];
            }
        });
    }
}
