import Sortable from "sortablejs";

document.addEventListener("readystatechange", () => {
    let url = $('.nav-menus').data('ordre-url');
    let option = {
        handle: '.sortable-el',
        animation: 150,
        onUpdate: function (event) {
            let el = $(event.from);
            let section = el.find('> .section-archi');
            let items = [];
            el.find('> .sortable-section').each(function () {
                let el = $(this);
                let section = el.find('> .section-archi');
                items.push(section.find('.id-archi').text());
            });
            axios.post(url, {ordre: items, parent_id: section.find('.id-archi').text()});
        }
    };

    new Sortable($('.nav-menus').get(0), {
            ...option,
            group: 'primary',
            draggable: '> .nav-archi-primary'
        }
    );
    $('.nav-menus').find('.nav-archi-primary').each(function () {
        if ($(this).find('.nav-archi-secondary').length > 0) {
            new Sortable(this, {
                ...option,
                group: $(this).find('.section-primary .id-archi').text(),
                draggable: '> .nav-archi-secondary'
            });
            $(this).find('.nav-archi-secondary').each(function () {
                if ($(this).find('.nav-archi-tertiary').length > 0) {
                    new Sortable(this, {
                        ...option,
                        group: $(this).find('.section-secondary .id-archi').text(),
                        draggable: '> .nav-archi-tertiary'
                    });
                    $(this).find('.nav-archi-tertiary').each(function () {
                        if ($(this).find('.nav-archi-quaternary').length > 0) {
                            new Sortable(this, {
                                ...option,
                                group: $(this).find('.section-tertiary .id-archi').text(),
                                draggable: '> .nav-archi-quaternary'
                            });
                        }
                    });
                }
            });
        }
    });

    $('.nav-menus input[name="actif"]').change(function () {
        let $input = $(this);
        let val = $input.is(':checked');

        // Si on dépublie
        if (!val) {
            // On remonte à la section
            let section = $input.parents('.section-archi').first();
            // On force le checked sur tous les sous actifs
            section.next('.sortable-section').find('input[name="actif"]').prop('checked', val);
        }
    })
});