import {defineConfig} from "vite";
import laravel from "laravel-vite-plugin";
import {fileURLToPath, URL} from "node:url";
import {globSync} from "glob";

let inputs = globSync("resources/js/*.js", {});

console.log(inputs)

export default defineConfig({
  resolve: {
    alias: {
      '@': fileURLToPath(new URL('./resources', import.meta.url)),
      '@public': fileURLToPath(new URL('./public', import.meta.url))
    },
  },
  plugins: [
    laravel({
      input: inputs,
      refresh: ["resources/**", "src/**", "app/**", "routes/**"],
    }),
  ],
});