@extends('bloom.layout.admin')

@section('bodyClass', 'page-edit')

@section('assets')
    @vite('resources/js/form.js', '/vendor/cms-module-menu')
    @vite('resources/js/multisites.js', '/vendor/cms-module-menu')
    @include('ckfinder::setup')
@endsection

@section('content')
    <div class="container-fluid">
        <div id="navbar-btns" class="mb-5 heading-text d-flex justify-content-between align-items-center sticky-top">
            <h1>{{ isset($menu) ? 'Modifier' : 'Ajouter' }} une rubrique</h1>

            <span class="wrapper-btns ml-auto">
                @if($menu->type === 'main')
                    @php($r="admin_menu_index")
                @elseif($menu->type === 'footer')
                    @php($r="admin_menu_footer")
                @endif
                <a href="{{ route($r) }}" class="btn-annuler btn btn-grisclair5 btn-primary">
                    Annuler
                </a>
                <a href="javascript:void(0);" class="btn-valider submit btn btn-grisclair5 btn-primary"
                   onclick="$('.main form').submit()">
                    Valider
                </a>
                <a href="javascript:void(0);" class="btn-publier submit btn btn-grisclair5 btn-primary"
                   onclick="publishAndSubmit()">
                    Valider et publier
                </a>
            </span>
        </div>

        <div class="content">
            <form action=" {{ route('admin_menu_save', $menu) }} " method="POST" id="form"
                  enctype="multipart/form-data">
                <div class="form-group row mb-0">
                    <div class="col-6 mb-4">
                        <x-forms.input-text
                                name="label"
                                text="Libellé"
                                :value="$menu->label"
                                form="admin"
                                :required="true"
                        />
                    </div>
                </div>

                @if($menu->type === "footer")
                    <div class="form-group mb-0">
                        <x-forms.input-custom-switch-radio
                                name="lien"
                                :id="['lien', 'form']"
                                :value="['Lien', 'Form']"
                                :checked="[is_null($menu->form_id), !(is_null($menu->form_id))]"
                                :text="['Lien', 'Formulaire']"
                                :required="true"
                        />
                    </div>
                @else
                    <div class="form-group row mb-0">
                        <div class="col-6">
                            <x-forms.input-custom-switch
                                    name="lien"
                                    id="lien"
                                    :checked="$menu->has_lien"
                                    text="Lien"
                                    :required="!(is_null($parent)) && count($parent->parents) === 2 || $menu->type === 'footer'"
                                    :disabled="!(isset($menu->can_have_lien))"
                            />
                        </div>
                    </div>
                @endif

                <div class="wrapper-exergue mb-4">
                    <div
                            class="form-group block-lien row mb-0 @if(!is_null($menu->form_id)) d-none @endif">
                        <div class="col-6">
                            <x-forms.input-custom-radio
                                    name="link_choice"
                                    text="Interne"
                                    value="interne"
                                    form="admin"
                                    :checked="!(is_null($menu->page_id)) || !(is_null($menu->miroir_id))"
                            />
                            <select class="form-control" name="page_id" id="page_id">
                                <option value=""></option>
                                @foreach($pages as $page)
                                    <x-modules.menu-pages-options
                                            :menu="$menu"
                                            :page="$page"
                                            :level="0"
                                    />
                                @endforeach
                            </select>
                        </div>

                        <div class="col-6">
                            <x-forms.input-custom-radio
                                    name="link_choice"
                                    text="Externe"
                                    value="externe"
                                    form="admin"
                                    :checked="isset($menu) && (!(is_null($menu->href)))"
                            />
                            <x-forms.input-text
                                    name="href"
                                    text=""
                                    :value="!(is_null($menu->href)) ? $menu->href : ''"
                            />
                        </div>
                    </div>

                    @if($menu->type == "footer")
                        <div class="form-group block-form row mb-0 @if(!is_null($menu->form_id)) d-none @endif">
                            <div class="col-6">
                                <x-forms.input-select
                                        name="form_id"
                                        text="Formulaire associé"
                                        :value="$menu->form_id"
                                        form="admin"
                                        :var="$forms"
                                        key="id"
                                        val="titre"
                                />
                            </div>
                        </div>
                    @endif
                </div>

                <div class="form-group row mb-0">
                    <div class="col-6 mb-4">
                        <label for="parent_id" class="control-label">
                            Rubrique parente
                        </label>

                        <div class="wrapper-inputs">
                            <select class="form-control disabled" name="parent_id" id="parent_id" disabled>
                                <option
                                        value="{{ isset($menu->parent_id) ?? '' }}"
                                >
                                    {{ isset($menu->parent_id) ? $menu->parent->label : '' }}
                                </option>
                            </select>
                            <input type="hidden" name="parent_id" value="{{ $menu->parent_id }}">
                        </div>
                    </div>
                </div>

                @if(empty($sites))
                @else
                    <div class="col-6 mb-4">
                        <label class="control-label">Liste des sites disponibles</label>
                        @if(count($sites) > 1)
                            <div class="custom-control custom-checkbox select-all-div">
                                <input type="checkbox" name="select-all-sites" class="custom-control-input"
                                       id="select-all-sites"
                                       checked
                                >
                                <label class="custom-control-label" for="select-all-sites"> Tout sélectionner /
                                    désélectionner</label>
                            </div>
                        @endif
                        @foreach($sites as $site)
                            <div class="custom-control custom-checkbox">
                                <input type="checkbox" name="site{{ $site->id }}"
                                       class="custom-control-input site-checkbox"
                                       id="site{{ $site->id }}"
                                       @if(isset($menu))
                                           @foreach($site_menus as $site_menu)
                                               {{ $site_menu->id === $site->id?'checked':'' }}
                                           @endforeach
                                       @else
                                           checked
                                        @endif
                                >
                                <label class="custom-control-label"
                                       for="site{{ $site->id }}">{{ $site->domaine_public }}</label>
                            </div>
                        @endforeach
                    </div>
                @endif
                <input type="hidden" name="type" value="{{ $menu->type }}">

                {{ csrf_field() }}
            </form>
        </div>
    </div>
@endsection