<?php

namespace Bloom\CMS\Modules\Menu\Http\Events\Handler;

use Bloom\CMS\Core\Contenus\Statut;
use Bloom\CMS\Modules\Menu\Http\Events\MenuArchived;
use Bloom\CMS\Modules\Menu\Http\Events\MenuDeleted;
use Bloom\CMS\Modules\Menu\Http\Events\MenuPublished;
use Bloom\CMS\Modules\Menu\Http\Events\MenuUnpublished;
use Bloom\CMS\Modules\Menu\Model\Menu;
use Illuminate\Support\Facades\Event;

class MenuHandler
{
    public function saving(Menu $page)
    {
        if (!$page->exists) {
            // Si la page n'existe pas, il s'agit d'une nouvelle page et donc
            // aucune redirection n'est à écrire ni aucun evenement de changement de statut
            return;
        }

        if ($page->isDirty('statut_id')) {
            // On trigger les events de publication / dépublication de page
            switch ((int)$page->statut_id) {
                case Statut::SUPPRIMER:
                    Event::dispatch(new MenuDeleted($page));
                    break;
                case Statut::ARCHIVE:
                    Event::dispatch(new MenuArchived($page));
                    break;
                case Statut::EN_COURS:
                    if ($page->getOriginal('statut_id') == Statut::PUBLIE) {
                        Event::dispatch(new MenuUnpublished($page));
                    }
                    break;
                case Statut::PUBLIE:
                    Event::dispatch(new MenuPublished($page));
            }
        }
    }
}
