@extends('bloom.layout.admin')

@section('bodyClass', 'page-edit page-sticky')

@section('assets')
    @vite('resources/js/form.js', '/vendor/cms-module-menu')
    @vite('resources/js/multisites.js', '/vendor/cms-module-menu')
    <script type="text/javascript" src="/js/ckfinder/ckfinder.js"></script>
    <script>CKFinder.config({connectorPath: '/ckfinder/connector'});</script>
@endsection

@section('content')
    <div class="container-fluid">
        <div id="navbar-btns" class="mb-5 heading-text d-flex justify-content-between align-items-center sticky-top">
            <h1>{{ isset($menu) ? 'Modifier' : 'Ajouter' }} un bouton sticky</h1>
            <span class="wrapper-btns ml-auto">
                <a href="{{ route('admin_menu_sticky') }}" class="btn-annuler btn btn-grisclair5 btn-primary">
                    Annuler
                </a>
                <a href="javascript:void(0);" class="btn-valider submit btn btn-grisclair5 btn-primary"
                   onclick="$('.main form').submit()">
                    Valider
                </a>
                <a href="javascript:void(0);" class="btn-publier submit btn btn-grisclair5 btn-primary"
                   onclick="publishAndSubmit()">
                    Valider et publier
                </a>
            </span>
        </div>

        <div class="content">
            <form action="{{ route('admin_menu_save', $menu) }}" method="POST" id="form"
                  enctype="multipart/form-data">
                <div class="form-group row mb-0">
                    <div class="col-6 mb-4">
                        <x-forms.input-text
                                name="label"
                                text="Libellé"
                                :value="$menu->label"
                                form="admin"
                        />
                    </div>
                </div>

                <div class="mb-4 p-0">
                    <div class="form-group mb-0">
                        <x-forms.input-custom-switch-radio
                                name="lien"
                                :id="['lien', 'form']"
                                :value="['Lien', 'Form']"
                                :checked="[is_null($menu->form_id), !(is_null($menu->form_id))]"
                                :text="['Lien', 'Formulaire']"
                                :required="true"
                        />
                    </div>

                    <div class="wrapper-exergue">
                        <div class="form-group block-lien row mb-0{% if menu.form_id is not null %} d-none{% endif %}">
                            <div class="col-6">
                                <x-forms.input-custom-radio
                                        name="link_choice"
                                        text="Interne"
                                        value="interne"
                                        form="admin"
                                        :checked="$menu->page"
                                />
                                <select class="form-control" name="page_id" id="page_id">
                                    <option value=""></option>
                                    @foreach($pages as $page)
                                        <x-options
                                                :menu="$menu"
                                                :page="$page"
                                        />
                                    @endforeach
                                </select>
                            </div>

                            <div class="col-6">
                                <x-forms.input-custom-radio
                                        name="link_choice"
                                        text="Externe"
                                        value="externe"
                                        form="admin"
                                        :checked="$menu->href"
                                />
                                <x-forms.input-text
                                        name="href"
                                        text=""
                                        :value="$menu->href"
                                />
                            </div>
                        </div>

                        <div class="form-group block-form row mb-0{% if menu.form_id is null %} d-none{% endif %}">
                            <div class="col-6">
                                <x-forms.input-select
                                        name="form_id"
                                        text="Formulaire associé"
                                        :value="$menu->form_id"
                                        form="admin"
                                        :var="$forms"
                                        key="id"
                                        val="titre"
                                />
                            </div>
                        </div>
                    </div>
                </div>

                <div class="form-group row mb-0">
                    <div class="col-3 mb-4">
                        <x-forms.input-custom-color-picker
                                name="couleur"
                                text="Couleur du texte du bouton"
                                :value="$menu->couleur"
                                form="admin"
                                :required="true"
                        />
                    </div>
                    <div class="col-3 mb-4">
                        <x-forms.input-custom-color-picker
                                name="couleur_bg"
                                text="Couleur de fond du bouton"
                                :value="$menu->couleur_bg"
                                form="admin"
                                :required="true"
                        />
                    </div>
                </div>

                <div class="form-group row mb-0">
                    <div class="col-6 mb-4">
                        <x-forms.input-custom-text-show-picto
                                name="picto"
                                text="Picto"
                                :value="$menu->picto"
                                form="admin"
                        />
                    </div>
                </div>

                <div class="form-group mb-4">
                    <label class="control-label"><strong>Applicabilité</strong></label>
                    @if(isset($applicables) && count($applicables) > 0)
                        <div class="wrapper-applicabilites wrapper-btns d-inline-flex justify-content-start flex-wrap">
                            @foreach($applicables as $applicable)
                                <x-forms.input-applicabilite
                                        :id="'applicable' . $applicable->id"
                                        :valeur="$applicable->value"
                                        :checked="str_contains($stickIns, $applicable->value . ';')"
                                        text=""
                                        :required="$applicable->titre"
                                        :disabled="false"
                                    />
                            @endforeach
                        </div>
                    @endif
                </div>

                <div class="form-group mb-4">
                    <label class="control-label"><strong>Pages concernées</strong></label>
                    <em>Pour sélectionner plusieurs pages, appuyer sur la touche CTRL et cliquer sur les pages
                        souhaitées.</em>
                    <select multiple="multiple" size="10" class="form-control select-multiple" name="page_id_conc[]"
                            id="page_id_conc">
                        @foreach($pages as $page)
                            {{ _self.pagesOptions($menu, $page,0, true, $stickIns) }}
                        @endforeach
                    </select>
                </div>
                @if(is_empty($sites))
                @else
                    <div class="col-6 mb-4">
                        <label class="control-label">Liste des sites disponibles</label>
                        @if(count($sites) > 1)
                            <div class="custom-control custom-checkbox select-all-div">
                                <input type="checkbox" name="select-all-sites" class="custom-control-input"
                                       id="select-all-sites"
                                       checked
                                >
                                <label class="custom-control-label" for="select-all-sites"> Tout sélectionner /
                                    désélectionner</label>
                            </div>
                        @endif
                        @foreach($sites as $site)
                            <div class="custom-control custom-checkbox">
                                <input type="checkbox" name="site{{ $site->id }}"
                                       class="custom-control-input site-checkbox"
                                       id="site{{ $site->id }}"
                                       @if(isset($menu))
                                           @foreach($site_menus as $site_menu)
                                               {{ $site_menu->id === $site->id ? 'checked' : '' }}
                                           @endforeach
                                       @else
                                           checked
                                        @endif
                                >
                                <label class="custom-control-label"
                                       for="site{{ $site->id }}">{{ $site->domaine_public }}</label>
                            </div>
                        @endforeach
                    </div>
                @endif
                <input type="hidden" name="type" value="sticky">

                {{ csrf_field() }}
            </form>
        </div>
    </div>
@endsection
