@extends('bloom.layout.admin')

@section('bodyClass', 'page-edit page-social')

@section('assets')
    @vite('resources/js/form.js', '/vendor/cms-module-menu')
    @vite('resources/js/multisites.js', '/vendor/cms-module-menu')
    <script type="text/javascript" src="/js/ckfinder/ckfinder.js"></script>
    <script>CKFinder.config({connectorPath: '/ckfinder/connector'});</script>
@endsection

@section('content')
    <div class="container-fluid">
        <div id="navbar-btns" class="mb-5 heading-text d-flex justify-content-between align-items-center sticky-top">
            <h1>{{ isset($menu) ? 'Modifier' : 'Ajouter'}} un réseau social</h1>

            <span class="wrapper-btns ml-auto">
                <a href="{{ route('admin_menu_social') }}" class="btn-annuler btn btn-grisclair5 btn-primary">
                    Annuler
                </a>
                <a href="javascript:void(0);" class="btn-valider submit btn btn-grisclair5 btn-primary"
                onclick="$('.main form').submit()">
                    Valider
                </a>
                <a href="javascript:void(0);" class="btn-publier submit btn btn-grisclair5 btn-primary"
                onclick="publishAndSubmit()">
                    Valider et publier
                </a>
            </span>
        </div>

        <div class="content">
            <form action="{{ route('admin_menu_save', $menu }}" method="POST" id="form" enctype="multipart/form-data">
                <div class="form-group row mb-0">
                    <div class="col-6 mb-4">
                        <x-forms.input-text
                                name="label"
                                text="Libellé"
                                :value="$menu->label"
                                form="admin"
                        />
                    </div>
                </div>

                <div class="form-group row mb-0">
                    <div class="col-6 mb-4">
                        <x-forms.input-text
                                name="href"
                                text="Lien"
                                :value="$menu->href"
                                placeholder="https://..."
                                form="admin"
                        />
                    </div>
                </div>

                <div class="form-group row mb-0">
                    <div class="col-6 mb-4">
                        <x-forms.input-custom-text-show-picto
                                name="picto"
                                text="Picto"
                                :value="$menu->picto"
                                form="admin"
                        />
                    </div>
                </div>
                @if(is_empty($sites))
                @else
                    <div class="col-6 mb-4">
                        <label class="control-label">Liste des sites disponibles</label>
                        @if(count($sites) > 1)
                            <div class="custom-control custom-checkbox select-all-div">
                                <input type="checkbox" name="select-all-sites" class="custom-control-input"
                                       id="select-all-sites"
                                       checked
                                >
                                <label class="custom-control-label" for="select-all-sites"> Tout sélectionner /
                                    désélectionner</label>
                            </div>
                        @endif
                        @foreach($sites as $site)
                            <div class="custom-control custom-checkbox">
                                <input type="checkbox" name="site{{ $site->id }}"
                                       class="custom-control-input site-checkbox"
                                       id="site{{ $site->id }}"
                                       @if(isset($menu))
                                           @foreach($site_menus as $site_menu)
                                               {{ $site_menu->id === $site->id?'checked':'' }}
                                           @endforeach
                                       @else
                                           checked
                                        @endif
                                >
                                <label class="custom-control-label"
                                       for="site{{ $site->id }}">{{ $site->domaine_public }}</label>
                            </div>
                        @endforeach
                    </div>
                @endif

                <input type="hidden" name="type" value="social">

                {{ csrf_field() }}
            </form>
        </div>
    </div>
@endsection