<?php

namespace App\View\Components;

use Closure;
use Illuminate\Contracts\View\View;
use Illuminate\View\Component;

class PagesOptions extends Component
{
    /**
     * The input menu
     *
     * @var array
     */
    public $menu;

    /**
     * The input pa
     *
     * @var array
     */
    public $pa;

    /**
     * The input lvl
     *
     * @var numeric
     */
    public $lvl;

    /**
     * The input choix_par_page
     *
     * @var numeric
     */
    public $choix_par_page;

    /**
     * The input stickIns
     *
     * @var numeric
     */
    public $stickIns;

    /**
     * Create a new component instance.
     *
     * @param array $menu
     * @param array $pa
     * @param numeric $lvl
     * @param numeric $choix_par_page
     * @param numeric $stickIns
     */
    public function __construct($menu, $pa, $lvl = 0, $choix_par_page = false, $stickIns = null)
    {
        $this->menu = $menu;
        $this->pa = $pa;
        $this->lvl = $lvl;
        $this->choix_par_page = $choix_par_page;
        $this->stickIns = $stickIns;
    }

    /**
     * Get the view / contents that represent the component.
     */
    public function render(): View|Closure|string
    {
        return view('components.pages-options-sticky');
    }
}