<?php

namespace App\View\Components;

use Closure;
use Illuminate\Contracts\View\View;
use Illuminate\View\Component;

class PagesOptions extends Component
{
    /**
     * The input menu
     *
     * @var array
     */
    public $menu;

    /**
     * The input pa
     *
     * @var array
     */
    public $pa;

    /**
     * The input lvl
     *
     * @var numeric
     */
    public $lvl;

    /**
     * Create a new component instance.
     *
     * @param array $menu
     * @param array $pa
     * @param numeric $lvl
     */
    public function __construct($menu, $pa, $lvl = 0)
    {
        $this->menu = $menu;
        $this->pa = $pa;
        $this->lvl = $lvl;
    }

    /**
     * Get the view / contents that represent the component.
     */
    public function render(): View|Closure|string
    {
        return view('components.pages-options');
    }
}