<?php
/**
 * Created by : loic
 * Created at : 21/04/2020
 *
 * In : IntelliJ IDEA
 */

namespace Bloom\CMS\Modules\Menu;

use Bloom\CMS\Modules\Architecture\Model\AdminMenu;
use Bloom\CMS\Modules\Architecture\Model\Module;
use Bloom\CMS\Modules\Menu\Http\Middleware\ModuleMiddleware;
use Bloom\CMS\Modules\Menu\Model\Menu;
use Illuminate\Database\Eloquent\Collection;
use Illuminate\Support\Facades\Route;
use Illuminate\Support\Facades\Schema;
use Twig\Extension\AbstractExtension;
use Twig\Extension\GlobalsInterface;
use Twig\TwigFunction;
use Twig\TwigTest;
use TwigBridge\Facade\Twig;

class CmsMenuServiceProvider extends \Illuminate\Support\ServiceProvider
{

    public function register(): void
    {
        $this->loadFactoriesFrom(dirname(__DIR__) . '/database/factories');
        $this->loadMigrationsFrom(dirname(__DIR__) . '/database/migrations');
        $this->loadViewsFrom(dirname(__DIR__) . '/resources/views', 'Menu');
        $dirname = dirname(__DIR__) . '/routes';
        foreach (scandir($dirname) as $file) {
            if (!in_array($file, ['.', '..'])) {
                Route::group(['middleware' => ['web', ModuleMiddleware::class]], function () use ($dirname, $file) {
                    $this->loadRoutesFrom($dirname . '/' . $file);
                });
            }
        }

        $this->publishes([
            dirname(__DIR__) . '/public' => public_path('/vendor/cms-module-menu')
        ], 'assets');

        $this->mergeConfigFrom(dirname(__DIR__) . '/config/menu.php', 'menu');
    }

    public static function getModule()
    {
        if (Schema::hasTable('modules')) {
            $module = Module::nom('menu')->firstOrCreate([
                'nom'        => 'menu',
                'nom_public' => 'Menu',
                'route'      => 'admin_menu_index',
            ]);
            if (!$module->exists) {
                $module->active = 1;
                $module->save();
            }

            return $module;
        }

        return false;
    }

    public function boot(): void
    {
        /**
         * @var Module $module
         */
        $module = self::getModule();

        if ($module && Schema::hasTable('admin_menus') && $module->subMenus->count() === 0) {
            AdminMenu::create([
                'module_id' => $module->id,
                'label'     => 'Principal',
                'route'     => 'admin_menu_index',
                'active'    => 1,
            ]);
            AdminMenu::create([
                'module_id' => $module->id,
                'label'     => 'Footer',
                'route'     => 'admin_menu_footer',
                'active'    => 1,
            ]);
            AdminMenu::create([
                'module_id' => $module->id,
                'label'     => 'Social',
                'route'     => 'admin_menu_social',
                'active'    => 1,
            ]);
            AdminMenu::create([
                'module_id' => $module->id,
                'label'     => 'Sticky',
                'route'     => 'admin_menu_sticky',
                'active'    => 1,
            ]);
        }

        Twig::addExtension(new class extends AbstractExtension implements GlobalsInterface {

            public function getTests()
            {
                return [
                    new TwigTest('onPage', function (Menu $menu) {
                        if ($menu->type !== Menu::STICKY) return true;


                        return false;
                    })
                ];
            }


            public function getFunctions()
            {
                return [
                    new TwigFunction('menu', function ($type): Collection {
                        return Menu::type($type)->published()->get();
                    })
                ];
            }


            /**
             * @inheritDoc
             */
            public function getGlobals()
            {
                return [
                    'menu_principal' => Menu::type(Menu::MAIN)->published()->get(),
                    'menu_social'    => Menu::type(Menu::SOCIAL)->published()->get(),
                    'menu_sticky'    => Menu::type(Menu::STICKY)->published()->get(),
                    'menu_footer'    => Menu::type(Menu::FOOTER)->published()->get(),
                ];
            }
        });
    }

}