<?php

namespace Bloom\CMS\Modules\Meas\Services;

use Bloom\CMS\Core\Http\Page;
use Illuminate\Support\Facades\Http;
use Illuminate\Support\Facades\Session;
use Exception;

/**
 * Class UnitagApi
 * @package Bloom\CMS\Modules\Meas\Services
 */
class UnitagApi
{
    /**
     * @var array
     */
    private $config;

    public function __construct(array $config)
    {
        $this->config = $config;
    }

    /**
     * @param $method
     * @param $url
     * @param array|null $content
     * @return mixed
     * @throws Exception
     */
    public function request($method, $url, ?array $content = null)
    {
        $base_url = $this->config['api_host'] . '/' . $url;

        try {
            $response = Http::accept('application/json')
                ->withHeaders([
                    'X-Unitag-ApiKey' => $this->config['api_key']
                ])
                ->$method($base_url, $content)
                ->body();

            if ($response === 'null') {
                return true;
            }

            $json = json_decode($response);
            if (is_null($json)) {
                // il faut que je teste le contenu de la variable, il peut s'agir d'une image dans le cas d'un dl de qrcode...
                $temp = tmpfile();
                fwrite($temp, $response);
                $mime = mime_content_type($temp);
                if (substr($mime, 0, 5) === 'image') {
                    fclose($temp);
                    return $response;
                }
                throw new Exception('Unknown error on Unitag API : ' . $response);
            }
            return $json;
        } catch (Exception $e) {
            throw new Exception('Error on Unitag API : ' . $e->getMessage());
        }
    }

    /**
     * @param Page $page
     * @return mixed|object
     * @throws Exception
     */
    public function createQrcode(Page $page)
    {
        try {
            $qrcode_config['data'] = [
                'type' => 'url',
                'resolution' => 'dynamic',
                'url' => url('/') . $page->pathname,
            ];
            if (!empty($this->config['template_id'])) {
                $qrcode_config['settings']['template_id'] = $this->config['template_id'];
            }
            $result =  $this->request(
                'POST',
                'qrcode',
                $qrcode_config
            );
            if (!$result || $result->status !== 'created') {
                throw new Exception('Unknown error on Unitag API : ' . $result);
            }

            return $result;
        } catch (Exception $e) {
            throw new Exception('Error on Unitag API : ' . $e->getMessage());
        }
    }

    /**
     * @param string $uuid
     * @return mixed|object
     * @throws Exception
     */
    public function getQrcode(string $uuid)
    {
        try {
            return $this->request(
                'POST',
                'asset/download/qrcode_bundle',
                [
                    'asset_uuid' => $uuid,
                    'format' => 'png',
                    'size' => 300,
                    'unit' => 'px',
                ]
            );
        } catch (Exception $e) {
            throw new Exception('Error on Unitag API : ' . $e->getMessage());
        }
    }

    /**
     * @param string $uuid
     * @return void
     * @throws Exception
     */
    public function deleteQrcode(string $uuid)
    {
        try {
            return $this->request(
                'DELETE',
                'qrcode/' . $uuid,
                null
            );
        } catch (Exception $e) {
            throw new Exception('Error on Unitag API : ' . $e->getMessage());
        }
    }
}
