<?php

/**
 * Created by IntelliJ IDEA.
 * User: loic
 * Date: 20/04/2021
 * Time: 12:34
 */

namespace Bloom\CMS\Modules\Meas\Handler;

use Bloom\CMS\Core\Contenus\Statut;
use Bloom\CMS\Core\Http\Events\PageStatutChange;
use Bloom\CMS\Modules\Meas\Model\Mea;

/**
 * Class PageHandler
 * @package Bloom\CMS\Modules\Meas\Handler
 */
class PageHandler
{
    public function statutChanged(PageStatutChange $statutChange)
    {
        $page = $statutChange->page;
        if ((int)$page->statut_id !== Statut::ARCHIVE) {
            // On ne traite que le cas ou la page se fait archivé
            return;
        }
        // On verifie si la page est liée a une mea
        $meas = Mea::query()->where('page_id', '=', $page->id)->get();
        if ($meas->count() > 0) {
            // La page a au moins 1 mea
            foreach ($meas as $mea) {
                $mea->statut_id = Statut::ARCHIVE;
                $mea->save();
            }
        }
    }
}
