<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddMeas extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('meas', function (Blueprint $table) {
            $table->id();
            $table->string('titre')->nullable();
            $table->string('soustitre')->nullable();
            $table->string('visuel_1');
            $table->string('visuel_2')->nullable();
            $table->dateTime('to_publish_at')->nullable();
            $table->dateTime('to_unpublish_at')->nullable();
            $table->string('ext_link')->nullable();
            $table->integer('int_link', false, true)->nullable();
            $table->string('type')->default('HP');
            $table->integer('rank', false, true);
            $table->integer('statut_id', false, true)->default(1);
            $table->integer('btn_id', false, true)->nullable();
            $table->integer('created_by', false, true)->default(1);
            $table->integer('last_modified_by', false, true)->default(1);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('meas');
    }
}
