<?php
/**
 * Created by : loic
 * Created at : 21/04/2020
 *
 * In : IntelliJ IDEA
 */

namespace Bloom\CMS\Modules\Meas;

use Bloom\CMS\Core\BloomProvider;
use Bloom\CMS\Core\Framework\Admin\AdminMenu;
use Bloom\CMS\Modules\Meas\Model\Mea;
use Illuminate\Database\Eloquent\Relations\Relation;

class CmsMeasServiceProvider extends BloomProvider
{
    protected $nom = "Accueil";
    protected $code = "mea";
    protected $has_admin = true;

    public function boot(): void
    {
        parent::boot();
        $this->addSubMenus([
            new AdminMenu([
                'label' => 'Visuel principal',
                'route' => 'admin_mea_index',
            ]),
            new AdminMenu([
                'label' => 'À l\'affiche',
                'route' => 'admin_mea_aff',
            ]),
        ]);

        Relation::morphMap([
            'meas' => Mea::class,
        ]);
    }
}
