<?php
/**
 * Created by : loic
 * Created at : 21/04/2020
 *
 * In : IntelliJ IDEA
 */

use Illuminate\Support\Facades\Route;

Route::group(['prefix' => config('app.admin'), 'middleware' => ['auth'], 'namespace' => 'Bloom\CMS\Modules\Meas\Http\Controllers'], function () {
    Route::group(['prefix' => 'meas'], function () {
        Route::get('/', 'AdminController@index')->name('admin_mea_index');
        Route::get('/affiche', 'AdminController@affiche')->name('admin_mea_aff');
        Route::get('/programmed/{type}', 'AdminController@programmed')->name('admin_mea_programmes');
        Route::get('/encours/{type}', 'AdminController@encours')->name('admin_mea_encours');
        Route::get('/edit/{mea?}', 'AdminController@edit')->name('admin_mea_edit');
        Route::post('/edit/{mea?}', 'AdminController@save')->name('admin_mea_save');
        Route::post('/reorder', 'AdminController@reorder')->name('admin_mea_reorder');
        Route::get('/{mea}/preview', 'AdminController@preview')->name('admin_mea_preview');
        Route::get('/{mea}/publish', 'AdminController@publish')->name('admin_mea_publish');
        Route::get('/{mea}/unpublish', 'AdminController@unpublish')->name('admin_mea_unpublish');
        Route::get('/{mea}/delete', 'AdminController@delete')->name('admin_mea_delete');
    });
});