<?php
/**
 * Created by : Jérôme
 * Created at : 19/06/2020
 *
 * In : IntelliJ IDEA
 */

namespace Bloom\CMS\Modules\Meas\Model;

use App\BtnCta;
use Carbon\Carbon;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Collection;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\Relation;
use Illuminate\Foundation\Auth\User;


/**
 * Class Mea
 * @package Bloom\CMS\Modules\Meas\Model
 *
 *
 * @property string $titre
 * @property string $soustitre
 * @property string $visuel_1
 * @property string $visuel_2
 * @property Carbon $to_publish_at
 * @property Carbon $to_unpublish_at
 * @property string $ext_link
 * @property integer $int_link
 * @property string $type
 * @property integer $rank
 * @property integer $statut_id
 * @property Statut $status
 * @property integer $btn_id
 * @property User $created_by
 * @property User $last_modified_by
 *
 *
 *
 * @method static Builder|static published()
 * @method static Builder|static programmed()
 * @method static Builder|static notProgrammed()
 * @method static Builder|static programmedFor(Carbon $date)
 * @method static Builder|static status(int $status)
 * @method static Builder|static type(string $type)
 */
class Mea extends Model
{

    const MAX_RANK = [
        Type::PRINCIPAL => 1,
        Type::AFFICHE => 4,
    ];

    protected $dates = [
        'to_publish_at',
        'to_unpublish_at',
    ];



    public function cree_par()
    {
        return $this->belongsTo(User::class, 'created_by');
    }

    public function derniere_modification_par()
    {
        return $this->belongsTo(User::class, 'last_modified_by');
    }

    public function btn()
    {
        return $this->belongsTo(BtnCta::class, 'btn_id');
    }


    //Gestion du statut
    public function scopeStatus(Builder $query, int $status)
    {
        return $query->where('statut_id', '=', $status);
    }

    public function scopeType(Builder $query, string $type)
    {
        return $query->where('type', '=', $type);
    }


    public function scopePublished(Builder $query)
    {
        return $this->scopeStatus($query, 1);
    }

    public function scopeProgrammed(Builder $query)
    {
        return $query->whereNotNull('to_publish_at')
            ->where('statut_id', '=', Statut::EN_COURS);

    }

    public function scopeNotProgrammed(Builder $query)
    {
        return $query->whereNull('to_publish_at')->where('id', '<>', 0);
    }

    public function publish(): bool
    {
        $this->to_publish_at = now();
        $this->statut_id = Statut::PUBLIE;

        $this->rank = $this->getRank();

        return $this->save();
    }

    public function unpublish(): bool
    {
        $this->statut_id = Statut::EN_COURS;
        $this->to_publish_at = null;
        $this->to_unpublish_at = null;

        // On récupère les meas publiées du même type, on supprime la meas à dépublier et on envoie la collection dans la fonction reOrder
        $type = $this->type;
        $meas = self::published()->where('type', $type)->orderBy('rank')->get();

        foreach ($meas as $key => $mea) {
            if ($mea->id == $this->id) $meas->forget($key);
        }

        $meas = $meas->values();
        $this->reOrder($meas);

        return $this->save();
    }

    public function softDelete(): bool
    {
        $this->statut_id = Statut::SUPPRIMER;

        return $this->save();
    }

    //Gestion des ranks
    public function getRank()
    {
        $type = $this->type;
        $meas = self::published()->where('type', $type)->orderBy('rank')->get();
        if ($meas->count() < self::MAX_RANK[$type]) {
            self::reOrder($meas);
            return $meas->count();
        } elseif ($this->to_publish_at <= Carbon::now()) {
            //Récupération du last rank dans le type donné et on la dépublie
            $last_mea = $meas->last();
            $last_mea->unpublish();
        }

        return self::MAX_RANK[$type] - 1;
    }

    //Réorganise les meas
    public function reOrder($meas)
    {
        foreach ($meas as $key => $mea) {
            $mea->rank = $key;
            $mea->save();
        }
    }


}