<?php

namespace Bloom\CMS\Modules\Meas\Model;

use Bloom\CMS\Core\Http\Page;
use Bloom\Cms\Sites\Models\Site;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Foundation\Auth\User;

/**
 * Class Element
 * @package Bloom\CMS\Modules\Meas\Models
 *
 * @property string    $uuid
 * @property integer   $page_id
 * @property integer   $created_by
 * @property integer   $updated_by
 *
 */
class Qrcode extends Model
{

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'uuid',
        'page_id',
        'created_by',
        'updated_by',
    ];

    /**
     * The attributes that should be hidden for arrays.
     *
     * @var array
     */
    protected $hidden = [
        'created_at',
        'updated_at',
    ];

    public function page(): BelongsTo
    {
        return $this->belongsTo(Page::class);
    }

    public function cree_par(): BelongsTo
    {
        return $this->belongsTo(User::class, 'created_by');
    }

    public function derniere_modification_par(): BelongsTo
    {
        return $this->belongsTo(User::class, 'updated_by');
    }

    public function sites()
    {
        return $this->belongsToMany(Site::class, 'site_qrcodes', 'qrcodes_id', 'sites_id')->withPivot(['created_at', 'updated_at']);
    }

}
