@extends('bloom.layout.admin')

@section('bodyClass', 'page-edit')

@section('assets')
    @vite('resources/js/listing.js', 'vendor/cms-module-mea')
    @vite('resources/js/form.js', 'vendor/cms-module-mea')
@endsection

@section('content')
    <div class="container-fluid admin-qrcode">
        <div id="navbar-btns" class="mb-5 heading-text d-flex justify-content-between align-items-center sticky-top">
            <div class="wrapper-titre">
                <h1>Mises en avant</h1>
                <h2>QR Code</h2>
            </div>
        </div>

        <div class="content">
            <div class="alert alert-success alert-block">
                Le nombre de QRCode est limité à {{ $limit }} par concession.<br>
                Quand cette limite est atteinte, il est nécessaire de supprimer un QRCode existant pour pouvoir en créer
                un nouveau.
            </div>

            <div class="col-12">
                <div class="section">
                    <h3 class="title">Créer un QR Code</h3>
                    <div class="underline"></div>
                </div>
                <form action="{{ route('admin_mea_qrcode_save', $qrcode) }}" method="POST" id="form">
                    <div class="form-group row justify-content-center align-items-end">
                        <div class="col-5 mb-4 input-wrapper">
                            <h4 class="input-label">URL cible</h4>
                            <x-forms.input-select
                                    name="page_id"
                                    text="Sélectionnez une page de votre site"
                                    :value="$qrcode->page_id"
                                    :required="true"
                                    :var="$pages"
                                    key="id"
                                    val="titre"
                            />
                        </div>
                        <div class="col-3 mb-4">
                            <div class="d-flex">
                                <a href="javascript:void(0);"
                                   class="btn-valider submit btn btn-grisclair5 btn-primary @if(count($qrcodes) >= $limit) disabled @endif"
                                   onclick="$('.main form').submit()">
                                    Générer le QR Code
                                </a>
                            </div>
                        </div>
                    </div>
                    {{ csrf_field() }}
                </form>
            </div>

            <div class="col-12">
                <div class="section">
                    <h3 class="title">Vos QR Codes</h3>
                    <div class="underline"></div>
                </div>
                @if(count($grcodes) > 0)
                    @foreach($qrcodes as $qrcode)
                        <div class="{{ count($qrcodes) > 1 ? 'row qrcode use-border' : 'row qrcode' }}">
                            <div class="title">
                                {{ $qrcode->page->titre }}
                            </div>
                            <div class="download">
                                <div class="d-flex">
                                    <a href="{{ route('admin_mea_qrcode_get', [$qrcode]) }}"
                                       class="btn btn-grisclair5 btn-primary row-button">
                                        Télécharger le QR Code
                                    </a>
                                </div>
                            </div>
                            <div class="delete">
                                <div class="d-flex">
                                    <a href="{{ route('admin_mea_qrcode_delete', [$qrcode]) }}"
                                       class="btn btn-grisclair5 btn-primary row-button">
                                        Supprimer
                                    </a>
                                </div>
                            </div>
                        </div>
                    @endforeach
                @else
                    <span class="no-qrcode">Vous n'avez pas encore créé de QR Code.</span>
                @endif
            </div>

        </div>
    </div>
@endsection
