@extends('bloom.layout.admin')

@section('bodyClass', 'page-edit')

@section('assets')
    <script src="{{ mix('/form.js', '/vendor/cms-module-mea') }}"></script>
    <script src="{{ asset('/plugins/ckeditor/ckeditor.js') }}"></script>
    <script type="text/javascript" src="/js/ckfinder/ckfinder.js"></script>
    <script>CKFinder.config({connectorPath: '/ckfinder/connector'});</script>
@endsection

@section('content')
    <div class="container-fluid">
        <div id="navbar-btns" class="mb-5 heading-text d-flex justify-content-between align-items-center sticky-top">
            <h1>{{ $mea->exists() ? 'Éditer' : 'Créer' }} une mise en avant</h1>

            <span class="wrapper-btns ml-auto">
				<a href="{{ route('admin_mea_liens_hp') }}"
                   class="btn-annuler btn btn-grisclair5 btn-primary">
					Annuler
				</a>
				<a href="javascript:void(0);" class="btn-valider submit btn btn-grisclair5 btn-primary"
                   onclick="$('.main form').submit()">
					Valider
				</a>
				<a href="javascript:void(0);" class="btn-publier submit btn btn-grisclair5 btn-primary"
                   onclick="publishAndSubmit()">
					Valider et publier
				</a>
			</span>
        </div>

        <div class="content">
            <form action="{{ route('admin_mea_liens_hp_save', $mea) }}" method="POST" id="form"
                  enctype="multipart/form-data">
                <div class="form-group row mb-0">
                    <div class="col-6 mb-4">
                        <x-forms.input-text
                                name="titre"
                                text="Libellé"
                                :value="$mea->titre"
                                form="admin"
                        />
                    </div>

                    <div class="col-6 mb-4">
                        <label class="control-label" for="page_id">Lien</label>
                        <x-forms.input-select
                                name="page_id"
                                text=""
                                :value="$mea->page_id"
                                :var="$pages"
                                key="id"
                                val="titre"
                        />
                    </div>
                </div>

                <input type="hidden" name="staut_id" value="{{ $mea->statut_id ?? 0  }}">
                {{ csrf_field() }}
            </form>
        </div>
    </div>
@endsection
