<?php

/**
 * Created by : loic
 * Created at : 21/04/2020
 *
 * In : IntelliJ IDEA
 */

namespace Bloom\CMS\Modules\Meas;

use Bloom\Cms\Configuration\Facade\Site;
use Bloom\CMS\Core\BloomProvider;
use Bloom\CMS\Core\Framework\Admin\AdminMenu;
use Bloom\CMS\Core\Http\Events\PageStatutChange;
use Bloom\CMS\Modules\Meas\Handler\PageHandler;
use Bloom\CMS\Modules\Meas\Http\Events\Subscriber\MeaSubscriber;
use Bloom\CMS\Modules\Meas\Model\Mea;
use Bloom\CMS\Modules\Meas\Services\UnitagApi;
use Illuminate\Database\Eloquent\Relations\Relation;
use Illuminate\Support\Facades\Event;

class CmsMeasServiceProvider extends BloomProvider
{
    protected $nom = "Accueil";
    protected $code = "mea";
    protected $has_admin = true;
    protected $icons = "home";

    public function register()
    {
        parent::register();
        Event::subscribe(MeaSubscriber::class);
        Event::listen(PageStatutChange::class, PageHandler::class . '@statutChanged');
        if (config('mea.module_qrcode') == true) {
            $this->app->singleton('unitag', function ($app) {
                return new UnitagApi($app['config']->get('qrcode'));
            });
        }
    }

    public function boot(): void
    {
        parent::boot();

        Site::getConfig('Largeur image Mea', 'VIGNETTE_MEA_IMG_L', 'Mea', '1900', '\d+', 'La largeur doit être un chiffre', false);
        Site::getConfig('Largeur image Mea', 'VIGNETTE_MEA_IMG_H', 'Mea', '600', '\d+', 'La largeur doit être un chiffre', false);

        $subMenus = [
            new AdminMenu([
                'label' => 'Visuel principal',
                'route' => 'admin_mea_index',
            ]),
            new AdminMenu([
                'label' => 'À l\'affiche',
                'route' => 'admin_mea_aff',
            ]),
        ];

        if (config('mea.module_qrcode') == true) {
            $subMenus[] = new AdminMenu([
                'label' => 'QR Code',
                'route' => 'admin_mea_qrcode',
            ]);
        }

        if (config('mea.module_bandeaux') == true) {
            $subMenus[] = new AdminMenu([
                'label' => 'Bandeaux',
                'route' => 'admin_mea_bandeaux',
            ]);
        }


        if (config('mea.module_video') == true) {
            $subMenus[] = new AdminMenu([
                'label' => 'Vidéo',
                'route' => 'admin_mea_video',
            ]);
        }

        $this->addSubMenus($subMenus);

        Relation::morphMap([
            'meas' => Mea::class,
        ]);

        $this->publishes([
            dirname(__DIR__) . '/public/build' => public_path('/vendor/cms-module-mea')
        ], 'assets');
    }
}
