@extends('bloom.layout.admin')

@php
    use \Carbon\Carbon;
@endphp

@section('bodyClass', 'page-listing')

@section('assets')
    @vite('resources/js/listing.js', 'vendor/cms-module-mea')
    @vite('resources/js/form.js', 'vendor/cms-module-mea')
@endsection

@section('content')
    @php
        $mea = isset($meas) && count($meas) > 0 ? $meas[0] : null;
        $onglet = '';
    @endphp

    <div class="container-fluid">
        <div id="navbar-btns" class="mb-5 heading-text d-flex justify-content-between align-items-center sticky-top">
            <div class="wrapper-titre">
                <h1>Accueil</h1>
                <h2>{{ $soustitre }}</h2>
            </div>

            @if(strtolower($type) === 'video' )
                <span class="wrapper-btns ml-auto">
          <a href="{{ strtolower($type) === 'main' ? route('admin_mea_index') : route('admin_mea_' . strtolower($type)) }}"
             class="btn-annuler btn btn-grisclair5 btn-primary">
            Annuler
          </a>
          @if(is_null($mea))
                        <a href="javascript:void(0);" class="btn-valider submit btn btn-grisclair5 btn-primary"
                           onclick="publishAndSubmit()">
              Valider
            </a>
                    @else
                        <a href="javascript:void(0);" class="btn-valider submit btn btn-grisclair5 btn-primary"
                           onclick="$('.main form').submit()">
              Valider
            </a>
                    @endif
        </span>
            @else
                <a href="{{ route('admin_mea_edit', ["type" => $type]) }}" class="btn btn-grisclair5 btn-primary">
                    Créer une mise en avant
                </a>
            @endif
        </div>

        <div class="content">
            @if(strtolower($type) === 'video' )
                <form action="{{ route('admin_mea_save', $mea) }}" method="POST" id="form">
                    <div class="form-group row mb-0">
                        <div class="col-6 mb-4">
                            <x-forms.input-text
                                    name="visuel_1"
                                    text="Identifiant de la vidéo YouTube"
                                    :value="$mea->visuel_1"
                                    form="admin"
                            />
                        </div>

                        <div class="col-6 mb-4">
                            <br style="font-size: 18px;">
                            <x-forms.input-custom-switch
                                    name="video_activee"
                                    id="video_activee"
                                    :checked="$mea->statut_id === 1"
                                    text="Activer"

                            />
                        </div>
                    </div>
                    <input type="hidden" name="statut_id"
                           value="{{ !(is_null($mea->statut_id) ? $mea->statut_id : 1 }}">
                    <input type="hidden" name="type" value="{{ !(is_null($mea->type) ? $mea->type : $type }}">
                    {{ csrf_field() }}
                </form>
            @else
                <ul class="list-nav-articles nav nav-pills mb-3">
                    @foreach($sub_menu_items as $item)
                        @if($item->active)
                            @php($onglet = str_replace('é', 'e', strtolower($item->title)))
                        @endif
                        <li class="nav-item">
                            <a href="{{ $item->href }}" {{ $item->active ? ' class="active"' : '' }}>
                                <span class="text">{{ $item->title }}</span>
                                <span class="badge badge-primary badge-pill">{{ $item->number }}</span>
                            </a>
                        </li>
                    @endforeach
                </ul>

                @if(strtolower($type) === 'aff' || strtolower($type) === 'bandeaux' )
                    {{--Mise en exergue MEA PUBLIEES--}}
                    @if($onglet === 'publiees')
                        <div class="wrapper-exergue mb-4">
                            Le nombre de mises en avant 'À l'affiche' publiées est limité à 4.<br>
                            Toute nouvelle publication supplémentaire aura pour conséquence de dépublier le dernier
                            contenu
                            affiché ci-dessous, c'est-à-dire celui d'ordre 4.
                        </div>
                    @endif
                    {{-- / Mise en exergue MEA PUBLIEES--}}--}}

                    {{-- Mise en exergue MEA PROGRAMMEES--}}
                    @if($onglet === 'programmees')
                        <div class="wrapper-exergue mb-4">
                            Lors de sa publication, une mise en avant est automatiquement placée en tête mises en avant
                            publiées.<br>
                            Ci-dessous, elles sont classées en fonction de leur future date de publication&nbsp;: la
                            publication
                            la
                            plus imminente est en première position.
                        </div>
                    @endif
                    {{-- / Mise en exergue MEA PROGRAMMEES--}}
                @endif

                @if(strtolower($type) === 'main')
                    {{-- Mise en exergue VIDEO--}}
                    <div class="wrapper-exergue mb-4">
                        Un seul 'Visuel principal' peut être publié.<br>
                        Toute nouvelle publication aura donc pour conséquence de dépublier le contenu précédement
                        visible
                        sur le
                        site.
                    </div>
                    {{-- / Mise en exergue VIDEO--}}
                @endif

                <table class="table table-admin">
                    <thead>
                    <tr>
                        {{-- Ordonnancement MEA PUBLIEES ET A L'AFFICHE--}}
                        @if((strtolower($type) === 'aff' || strtolower($type) === 'bandeaux') && $onglet === 'publiees')
                            <th scope="col">Ordre</th>
                        @endif
                        {{-- / Ordonnancement MEA PUBLIEES ET A L'AFFICHE--}}

                        <th scope="col">Vignette</th>
                        <th scope="col">
                            <span class="text">Id</span>
                        </th>
                        <th scope="col">
                            <span class="text">Titre</span>
                        </th>
                        <th scope="col">
                            <span class="text">Créé le</span>
                        </th>
                        <th scope="col">
                            <span class="text">Modifié le</span>
                        </th>
                        <th scope="col">
                            <span class="text">
                                Dates de<br>
                                publication
                            </span>
                        </th>
                        <th scope="col" colspan="2"></th>
                    </tr>
                    </thead>
                    <tbody id="sortable-wrapper" data-url="{{ route('admin_mea_reorder') }}">
                    {% for mea in meas if meas|length > 0)
                    @if(isset($meas) && count($meas) > 0)
                        @foreach($meas as $mea)

                            <tr @if($onglet === 'publiees') class="sortable-section" @endif>
                                {{-- Ordonnancement MEA PUBLIEES--}}
                                @if((strtolower($type) === 'aff' || strtolower($type) === 'bandeaux') && $onglet === 'publiees')
                                    <td class="sortable-el">
                                        <span class="fa fa-arrows"></span>
                                        <span class="text">{{ $mea->rank + 1 }}</span>
                                    </td>
                                @endif
                                {{-- / Ordonnancement MEA PUBLIEES--}}

                                <td><img src="{{ $mea->visuel_1 }}" alt="{{ $mea->titre }}" class="img-fluid"></td>
                                <td class="id-mea">{{ $mea->id }}</td>
                                <td>{{ $mea->titre }}</td>
                                <td>
                            <span class="tooltip-elmt d-inline-block" data-toggle="tooltip" data-placement="bottom"
                                  title="{{ $mea->cree_par->name }}">
                                {{ Carbon::parse($mea->created_at)->format('d/m/Y') }}
                            </span>
                                </td>
                                <td>
                            <span class="tooltip-elmt d-inline-block" data-toggle="tooltip" data-placement="bottom"
                                  title="{{ $mea->derniere_modification_par->name }}">
                                {{ Carbon::parse($mea->updated_at)->format('d/m/Y') }}
                            </span>
                                </td>
                                <td>
                                    @if($mea->to_publish_at)
                                        <span class="tooltip-elmt d-inline-block">
                                    du
                                    {{ Carbon::parse($mea->to_publish_at)->format('d/m/Y') }}<br>
                                    au
                                    {{ Carbon::parse($mea->to_unpublish_at)->format('d/m/Y') }}
                                </span>
                                    @endif
                                </td>
                                <td class="btn-group-cta btn-group-sm text-right">
                                    <x-action-list
                                            :id="$actions"
                                            :actions="$mea"
                                            :item="$type"
                                    />

                                    @if(count($sub_actions) > 0)
                                        <x-action-dropdown
                                                :id="'dropdownMenu0' . $loop->index"
                                                :actions="$sub_actions"
                                                :item="$mea"
                                        />
                                    @endif
                                </td>
                            </tr>
                        @endforeach
                    @endif
                    </tbody>
                </table>
            @endif
        </div>
    </div>
@endsection
