@extends('bloom.layout.admin')

@section('bodyClass', 'page-listing')

@section('assets')
    @vite('resources/js/listing.js', 'vendor/cms-module-mea')
    @vite('resources/js/form.js', 'vendor/cms-module-mea')
@endsection

@section('content')
    @php($mea = isset($meas) && count($meas) > 0 ? $meas[0] : null)
    <div class="container-fluid">
        <div id="navbar-btns" class="mb-5 heading-text d-flex justify-content-between align-items-center sticky-top">
            <div class="wrapper-titre">
                <h1>Accueil</h1>
                <h2>Liens Homepage</h2>
            </div>

            <a href="{{ route('admin_mea_liens_hp_edit') }}" class="btn btn-grisclair5 btn-primary">
                Créer une mise en avant
            </a>
        </div>

        <div class="content">
            <table class="table table-admin">
                <thead>
                <tr>
                    <th scope="col">
                        <span class="text">Ordre</span>
                    </th>
                    <th scope="col">
                        <span class="text">Id</span>
                    </th>
                    <th scope="col">
                        <span class="text">Libellé</span>
                    </th>
                    <th scope="col">
                        <span class="text">Page cible</span>
                    </th>
                    <th scope="col">
                        <span class="text">Créé le</span>
                    </th>
                    <th scope="col">
                        <span class="text">Modifié le</span>
                    </th>
                    <th scope="col">
                        <span class="text">Actif</span>
                    </th>
                    <th scope="col" colspan="2"></th>
                </tr>
                </thead>
                <tbody id="sortable-wrapper" data-url="{{ route('admin_mea_liens_hp_reorder') }}">
                @if(isset($meas) && count($meas) > 0)
                    @foreach($meas as $mea)
                        <tr class="sortable-section">
                            {{--Ordonnancement MEA PUBLIEES --}}
                            <td class="sortable-el">
                                <span class="fa fa-arrows"></span>
                                <span class="text">{{ $mea->rank + 1 }}</span>
                            </td>
                            {{--/ Ordonnancement MEA PUBLIEES --}}

                            <td class="id-mea">{{ $mea->id }}</td>
                            <td>{{ $mea->titre }}</td>
                            <td>{{ $mea->page->titre }}</td>
                            <td>
                          <span class="tooltip-elmt d-inline-block" data-toggle="tooltip" data-placement="bottom"
                                title="{{ $mea->cree_par->name }}">
                            {{ Carbon::parser($mea->created_at)->format('d/m/Y') }}
                          </span>
                            </td>
                            <td>
                          <span class="tooltip-elmt d-inline-block" data-toggle="tooltip" data-placement="bottom"
                                title="{{ $mea->modifie_par->name }}">
                            {{ Carbon::parser($mea->modified_at)->format('d/m/Y') }}
                          </span>
                            </td>
                            <td>
                                <x-forms.input-custom-switch
                                        name="actif"
                                        :id="'actif-' . $mea->id"
                                        :checked="$mea->statut_id === 1"
                                        :url="route('admin_mea_liens_hp_togglePublish', $mea)"
                                />
                            </td>
                            <td>
                          <span class="tooltip-elmt d-inline-block" data-toggle="tooltip" data-placement="bottom"
                                title="{{ $mea->derniere_modification_par->name }}">
                            {{ Carbon::parser($mea->updated_at)->format('d/m/Y') }}
                          </span>
                            </td>
                            <td class="btn-group-cta btn-group-sm text-right">
                                <a href="{{ route('admin_mea_liens_hp_edit', $mea) }}"
                                   class="btn btn-cta btn-grisclair5">
                                    Modifier
                                </a>
                                <a href="{{ route('admin_mea_liens_hp_delete', $mea) }}"
                                   class="btn btn-cta btn-grisclair5">
                                    Supprimer
                                </a>
                            </td>
                        </tr>
                    @endforeach
                @endif
                </tbody>
            </table>
        </div>
    </div>
@endsection
