<?php
/**
 * Created by : Jérôme
 * Created at : 19/06/2020
 *
 * In : IntelliJ IDEA
 */

namespace Bloom\CMS\Modules\Meas\Http\Controllers;


use Bloom\CMS\Modules\Architecture\Helpers\Actions;
use Bloom\CMS\Modules\Architecture\Model\Page;
use Bloom\CMS\Modules\Meas\Model\Mea;
use Bloom\CMS\Modules\Meas\Model\Statut;
use Bloom\CMS\Modules\Meas\Model\Type;
use Carbon\Carbon;
use http\Env\Request;
use Illuminate\Database\Eloquent\Collection;
use Illuminate\Routing\Controller;
use Illuminate\Support\Arr;
use Illuminate\Support\Facades\Auth;


class AdminController extends Controller
{

    public function getSubMenu(): array
    {
        if (request('type')) {
            $type = request('type');
        } else {
            $type = request()->route()->getName() === 'admin_mea_index' ? Type::PRINCIPAL : Type::AFFICHE;
        }

        return [
            'sub_menu_items' => [
                [
                    'title' => 'Publié' . ($type !== Type::PRINCIPAL ? 'es' : ''),
                    'href' => $type === Type::PRINCIPAL ? route('admin_mea_index') : route('admin_mea_aff'),
                    'number' => Mea::type($type)->published()->count(),
                    'active' => request()->route()->getName() === 'admin_mea_index' || request()->route()->getName() === 'admin_mea_aff',
                ],
                [
                    'title' => 'Programmé' . ($type !== Type::PRINCIPAL ? 'es' : 's'),
                    'href' => route('admin_mea_programmes', $type),
                    'number' => Mea::type($type)->programmed()->count(),
                    'active' => request()->route()->getName() === 'admin_mea_programmes',
                ],
                [
                    'title' => 'Non publié' . ($type !== Type::PRINCIPAL ? 'es' : 's'),
                    'href' => route('admin_mea_encours', $type),
                    'number' => Mea::type($type)->status(Statut::EN_COURS)->notProgrammed()->count(),
                    'active' => request()->route()->getName() === 'admin_mea_encours',
                ],
            ]
        ];
    }

    public function getViewData(array $data): array
    {
        if (request('type')) {
            $data['type'] = request('type');
        } else {
            $data['type'] = request()->route()->getName() === 'admin_mea_index' ? Type::PRINCIPAL : Type::AFFICHE;
        }

        return array_merge($data, $this->getSubMenu());
    }

    public function getDefaultActions(bool $with_sub = true): array
    {
        $actions = new Actions();
        $actions
            ->addAction('Modifier', 'admin_mea_edit')
            ->addNewTabAction('Prévisualiser', 'admin_mea_preview')
            ->addAction('Publier', 'admin_mea_publish');
        if ($with_sub) {
            $sub_actions = new Actions('sub_actions');
            $sub_actions
                ->addAction('Supprimer', 'admin_mea_delete');
        }

        return array_merge($actions->toArray(), isset($sub_actions) ? $sub_actions->toArray() : []);
    }

    public function getSorted(Collection $collection)
    {
        $sort = function (Mea $mea) {
            return Arr::get(Arr::dot($mea->toArray()), request('orderBy', 'rank'));
        };

        return [
            'meas' => request('order', 'asc') === "asc" ?
                $collection->sortBy($sort) :
                $collection->sortByDesc($sort),
            'order' => [
                'item' => request('orderBy', 'rank'),
                'order' => request('order', 'asc'),
            ]
        ];
    }

    public function index()
    {
        $actions = $this->getDefaultActions();

        // On remplace la 3eme action du menu
        $actions['actions'][2] = [
            'name' => 'Dépublier', 'href' => 'admin_mea_unpublish'
        ];

        $data = array_merge($this->getSorted(Mea::type(Type::PRINCIPAL)->published()->get()), $actions);

        $data['type'] = Type::PRINCIPAL;
        $data['soustitre'] = 'Visuel principal';


        return view('Meas::admin.listing', $this->getViewData($data));
    }

    public function affiche()
    {
        $actions = $this->getDefaultActions();

        // On remplace la 3eme action du menu
        $actions['actions'][2] = [
            'name' => 'Dépublier', 'href' => 'admin_mea_unpublish'
        ];

        $data = array_merge($this->getSorted(Mea::type(Type::AFFICHE)->published()->get()), $actions);

        $data['type'] = Type::AFFICHE;
        $data['soustitre'] = 'À l\'affiche';


        return view('Meas::admin.listing', $this->getViewData($data));
    }

    public function programmed()
    {
        $type = request('type', Type::PRINCIPAL);
        $data = array_merge($this->getSorted(Mea::type($type)->programmed()->get()), $this->getDefaultActions());
        $data['soustitre'] = $type === Type::PRINCIPAL ? 'Visuel principal' : 'À l\'affiche';

        return view('Meas::admin.listing', $this->getViewData($data));
    }

    public function encours()
    {
        $type = request('type', Type::PRINCIPAL);
        $data = array_merge($this->getSorted(Mea::type($type)->status(Statut::EN_COURS)->notProgrammed()->get()), $this->getDefaultActions());
        $data['soustitre'] = $type === Type::PRINCIPAL ? 'Visuel principal' : 'À l\'affiche';

        return view('Meas::admin.listing', $this->getViewData($data));
    }

    public function edit(Mea $mea)
    {
        $pages = Page::published()->get();
        $data['type'] = request('type', Type::PRINCIPAL);

        return view('Meas::admin.edit', compact('mea', 'pages'));
    }

    public function save(Mea $mea)
    {
        $user_id = Auth::user()->getAuthIdentifier();
        $type = request('type');

        if (request()->has('statut_id')) {
            $statut = request('statut_id');
        } else {
            if ($mea !== null && $mea->count() > 0) {
                $statut = $mea->statut_id ?: Statut::EN_COURS;
            } else {
                $statut = Statut::EN_COURS;
            }
        }

        if (!$mea->exists) {
            // Nouvelle mea

            // On crée la mea
            $mea->titre = request('titre');
            $mea->soustitre = request('soustitre');
            $mea->visuel_1 = request('visuel_1');
            $mea->visuel_2 = request('visuel_2');
            $mea->to_publish_at = request('date_pub');
            $mea->to_unpublish_at = request('date_depub');
            $mea->created_by = $user_id;
            $mea->last_modified_by = $user_id;

            //Gestion du lien
            if (request('link_choice') == 'interne') {
                $mea->int_link = request('page_id');
            } else {
                $mea->ext_link = request('href');
            }


            // Type MEA
            $mea->type = $type;

            // Traitement du statut
            if (request()->has('statut_id')) {
                $statut = request('statut_id');
            } else {
                if ($mea !== null && $mea->count() > 0) {
                    $statut = $mea->statut_id ?: 2;
                } else {
                    $statut = 2;
                }
            }

            if (request('publish_at') && Carbon::createFromFormat('Y-m-d', request('publish_at'))->isAfter(now())) {
                $statut = 2;
            }
            if (request('statut_id') == 1) {
                $statut = 1;
                $mea->to_publish_at = now();
            }
            $mea->statut_id = $statut;

            //Gestion du rank
            $mea->rank = $mea->getRank();         //Rank de la nouvelle MEA

            $mea->save();

        } else {
            // Edition


            $mea->titre = request('titre');
            $mea->soustitre = request('soustitre');
            $mea->visuel_1 = request('visuel_1');
            $mea->visuel_2 = request('visuel_2');
            $mea->to_publish_at = request('date_pub');
            $mea->to_unpublish_at = request('date_depub');
            $mea->created_by = $user_id;
            $mea->last_modified_by = $user_id;

            //Gestion du lien
            if (request('link_choice') == 'interne') {
                $mea->int_link = request('page_id');
            } else {
                $mea->ext_link = request('href');
            }

            if (request('date_pub') && Carbon::createFromFormat('Y-m-d', request('date_pub'))->isAfter(now())) {
                $statut = 2;
            }
            $mea->statut_id = $statut;

            $mea->save();
        }

        if ($statut == Statut::EN_COURS) {
            if ($mea->to_publish_at) {
                return redirect()->route('admin_mea_programmes');
            }

            return redirect()->route('admin_mea_encours');
        }

        return redirect()->route('admin_mea_index');
    }

    public function preview(Mea $mea)
    {
        return $mea->getHandler()->single($mea);
    }

    public function publish(Mea $mea)
    {
        $mea->publish();

        return redirect()->back();
    }

    public function unpublish(Mea $mea)
    {
        $mea->unpublish();

        return redirect()->back();
    }

    public function delete(Mea $mea)
    {
        $mea->softDelete();

        return redirect()->back();
    }

    public function reorder()
    {
        $ordre = request('ordre', []);

        $meas = Mea::published()->get();

        foreach ($meas as $mea) {
            /**
             * @var Mea $mea
             */
            $mea->rank = array_search($mea->id, $ordre, false);
            $mea->save();
        }

    }


}