<?php
/**
 * Created by : loic
 * Created at : 21/04/2020
 *
 * In : IntelliJ IDEA
 */

use Bloom\Cms\Configuration\Facade\Site;
use Illuminate\Support\Facades\Route;


Route::group(['middleware' => [function($request, $next) {
	return $next($request)
	->withCookie(new \Symfony\Component\HttpFoundation\Cookie('CMS_MODULE', 'mea', 0, '/', null,null,false))
	->withCookie(new \Symfony\Component\HttpFoundation\Cookie('CMS_IMG_L', ( null !== Site::value('VIGNETTE_MEA_IMG_L') ? Site::value('VIGNETTE_MEA_IMG_L') : 2000 ),0, '/', null,null,false))
	->withCookie(new \Symfony\Component\HttpFoundation\Cookie('CMS_IMG_H', ( null !== Site::value('VIGNETTE_MEA_IMG_H') ? Site::value('VIGNETTE_MEA_IMG_H') : 1300 ),0, '/', null,null,false)) ; }]], function() {

	Route::get('/', 'AdminController@index')->name('index');
	Route::get('/affiche', 'AdminController@affiche')->name('aff');
	Route::get('/programmed/{type}', 'AdminController@programmed')->name('programmes');
	Route::get('/encours/{type}', 'AdminController@encours')->name('encours');
	Route::get('/archived/{type}', 'AdminController@archived')->name('archived');

	Route::get('/edit/{mea?}', 'AdminController@edit')->name('edit');
	Route::post('/edit/{mea?}', 'AdminController@save')->name('save');
	Route::post('/reorder', 'AdminController@reorder')->name('reorder');
	Route::get('/{mea}/preview', 'AdminController@preview')->name('preview');
	Route::get('/{mea}/publish', 'AdminController@publish')->name('publish');
	Route::get('/{mea}/unpublish', 'AdminController@unpublish')->name('unpublish');
	Route::get('/{mea}/archive', 'AdminController@archive')->name('archive');
	Route::get('/{mea}/duplicate', 'AdminController@duplicate')->name('duplicate');
	Route::get('/{mea}/delete', 'AdminController@delete')->name('delete');
});
