<?php

namespace Bloom\CMS\Modules\Meas\Http\Events\Handler;

use Bloom\CMS\Core\Contenus\Statut;
use Bloom\CMS\Modules\Meas\Http\Events\MeaArchived;
use Bloom\CMS\Modules\Meas\Http\Events\MeaDeleted;
use Bloom\CMS\Modules\Meas\Http\Events\MeaPublished;
use Bloom\CMS\Modules\Meas\Http\Events\MeaUnpublished;
use Bloom\CMS\Modules\Meas\Model\Mea;
use Illuminate\Support\Facades\Event;

class MeaHandler
{
    public function saving(Mea $page)
    {
        if (!$page->exists) {
            // Si la page n'existe pas, il s'agit d'une nouvelle page et donc
            // aucune redirection n'est à écrire ni aucun evenement de changement de statut
            return;
        }

        if ($page->isDirty('statut_id')) {
            // On trigger les events de publication / dépublication de page
            switch ((int)$page->statut_id) {
                case Statut::SUPPRIMER:
                    Event::dispatch(new MeaDeleted($page));
                    break;
                case Statut::ARCHIVE:
                    Event::dispatch(new MeaArchived($page));
                    break;
                case Statut::EN_COURS:
                    if ($page->getOriginal('statut_id') == Statut::PUBLIE) {
                        Event::dispatch(new MeaUnpublished($page));
                    }
                    break;
                case Statut::PUBLIE:
                    Event::dispatch(new MeaPublished($page));
            }
        }
    }
}
