@extends('bloom.layout.admin')

@section('bodyClass', 'page-edit')

@section('assets')
    @vite('resources/js/form.js', 'vendor/cms-module-mea')
    @vite('resources/js/multisites.js', 'vendor/cms-module-mea')
    <script src="/plugins/ckeditor/ckeditor.js"></script>
    @include('ckfinder::setup')
@endsection

@section('content')
    @php($type = isset($mea->type) ? $mea->type : app()->request->get('type'))
    <div class="container-fluid">
        <div id="navbar-btns" class="mb-5 heading-text d-flex justify-content-between align-items-center sticky-top">
            <h1>{{ $mea->exists ? 'Éditer' : 'Créer' }}
                {{ strtolower($type) === 'aff' ? 'une mise en avant' : 'un visuel' }}</h1>

            <span class="wrapper-btns ml-auto">
				<a href="{{ strtolower($type) === 'main' ? route('admin_mea_index') : route('admin_mea_' . strtolower($type)) }}"
                   class="btn-annuler btn btn-grisclair5 btn-primary">
					Annuler
				</a>
				<a href="javascript:void(0);" class="btn-valider submit btn btn-grisclair5 btn-primary"
                   onclick="$('.main form').submit()">
					Valider
				</a>
				<a href="javascript:void(0);" class="btn-publier submit btn btn-grisclair5 btn-primary"
                   onclick="publishAndSubmit()">
					Valider et publier
				</a>
				<a href="@if($mea->exists) {{ route('admin_mea_preview', $mea) }} @else javascript:void(0); @endif"
                   target="_blank"
                   class="btn-previsualier btn btn-grisclair5 btn-primary @if(!$mea->exists) disabled @endif"
                   title="@if(!$mea->exists) Sauvegarder pour prévisualiser @endif">
					Prévisualiser
				</a>
			</span>
        </div>

        <div class="content">
            <form action="{{ route('admin_mea_save', $mea) }}" method="POST" id="form" enctype="multipart/form-data">
                <div class="form-group row mb-0">
                    <div class="col-6 mb-4">
                        <x-forms.input-text
                                name="titre"
                                text="Titre"
                                :value="$mea->titre"
                                form="admin"
                        />
                    </div>
                </div>

                @if(strtolower($type) === 'bandeaux')
                    <div class="form-group mb-0">
                        <div class="mb-4">
                            <div class="wrapper-editor">
                                <x-forms.editor
                                        name="mentions"
                                        text="Mentions <em>(facultatif)</em>"
                                        :value="$mea->mentions"
                                        form="admin"
                                        format="mini"
                                />
                            </div>
                        </div>
                    </div>
                @endif

                @if(strtolower($type) === 'main')
                    {{--VISUEL PRINCIPAL --}}
                    <div class="form-group row mb-0">
                        <div class="col-6 mb-4">
                            <x-forms.input-text
                                    name="soustitre"
                                    text="Sous-titre"
                                    :value="$mea->soustitre"
                                    form="admin"
                            />
                        </div>
                    </div>
                    {{--/ VISUEL PRINCIPAL --}}
                @endif

                <div class="form-group mb-4">
                    <label for="visuel_1" class="control-label">
                        Visuel
                        @if(strtolower($type) === 'main')
                            bureau (1900x600px)
                        @endif
                        @if(strtolower($type) === 'aff')
                            (290x220px)
                        @endif
                        @if(strtolower($type) === 'bandeaux')
                            (590x390px)
                        @endif
                    </label>
                    @if(strtolower($type) === 'main' || strtolower($type) === 'bandeaux')
                        <x-forms.input-custom-file-with-image
                                name="visuel_1"
                                text="Parcourir"
                                form="admin"
                                :required="true"
                                :value="$mea->visuel_1"
                        />
                    @endif
                    @if(strtolower($type) === 'aff')
                        <x-forms.input-custom-file-with-image
                                name="visuel_1"
                                text="Parcourir"
                                form="admin"
                                :required="true"
                                :value="$mea->visuel_1"
                        />
                    @endif
                </div>

                @if(strtolower($type) === 'main')
                    <div class="form-group mb-4">
                        <label for="visuel_2" class="control-label">Visuel mobile (800x400px)</label>
                        <x-forms.input-custom-file-with-image
                                name="visuel_2"
                                text="Parcourir"
                                form="admin"
                                :required="true"
                                :value="$mea->visuel_2"
                        />
                    </div>
                @endif

                <div class="form-group mb-4">
                    <label class="control-label" for="date_pub">Dates de publication</label>

                    <div class="row w-75">
                        {{--{{ field.calendrier('mea', 'date_pub', 'date_depub', $mea) }}--}}
                    </div>
                </div>

                @if(strtolower($type) === 'aff' || strtolower($type) === 'bandeaux')
                    {{--A L'AFFICHE --}}
                    <div class="form-group row mb-2">
                        <div class="col-6">
                            <x-forms.input-custom-switch
                                    name="lien"
                                    id="lien"
                                    :checked="($mea->href || $mea->page_id) ? true : false"
                                    text="Lien"
                            />
                        </div>
                    </div>

                    @if(strtolower($type) === 'bandeaux')
                        <div class="form-group row mb-0">
                            <div class="col-6 mb-2">
                                <x-forms.input-text
                                        name="soustitre"
                                        text="Texte du bouton"
                                        :value="$mea->soustitre"
                                        form="admin"
                                />
                            </div>
                        </div>
                    @endif

                    <div class="wrapper-exergue mb-4">
                        <div class="form-group row mb-0">
                            <div class="col-6">
                                <x-forms.input-custom-radio
                                        name="link_choice"
                                        text="Interne"
                                        value="interne"
                                        form="admin"
                                        :checked="isset($mea->page_id)"
                                />
                                <x-forms.input-select
                                        name="page_id"
                                        text=""
                                        :value="$mea->page_id"
                                        :var="$pages"
                                        key="id"
                                        val="titre"
                                />
                            </div>

                            <div class="col-6">
                                <x-forms.input-custom-radio
                                        name="link_choice"
                                        text="Externe"
                                        value="externe"
                                        form="admin"
                                        :checked="isset($mea->href) && $mea->href !== ''"
                                />
                                <x-forms.input-text
                                        name="href"
                                        text=""
                                        :value="$mea->href ?? ''"
                                />
                            </div>
                        </div>
                    </div>
                    {{--/ A L'AFFICHE --}}
                @endif

                @if(strtolower($type) !== 'bandeaux')
                    <div class="form-group mb-0">
                        <div class="mb-4">
                            <div class="wrapper-editor">
                                <x-forms.editor
                                        name="mentions"
                                        text="Mentions <em>(facultatif)</em>"
                                        :value="$mea->mentions"
                                        form="admin"
                                        format="mini"
                                />
                            </div>
                        </div>
                    </div>
                @endif

                <!-- le user est superadmin si auth_user().getAccessLevel() === 1 -->
                @if(!empty($sites))
                    <div class="form-group mb-4">
                        <div class="wrapper-inputs">
                            <label for="vignette" class="control-label">Liste des sites disponibles</label>
                            @if(count($sites) > 1)
                                <div class="custom-control custom-checkbox select-all-div">
                                    <input type="checkbox" name="select-all-sites" class="custom-control-input"
                                           id="select-all-sites"
                                           checked
                                    >
                                    <label class="custom-control-label" for="select-all-sites"> Tout sélectionner /
                                        désélectionner</label>
                                </div>
                            @endif
                            @foreach($sites as $site)
                                <div class="custom-control custom-checkbox">
                                    <input type="checkbox" value="{{ $site->id }}" name="multisite[]"
                                           class="custom-control-input site-checkbox"
                                           id="site{{ $site->id }}"
                                           @if($mea->exists)
                                               @foreach($site_meas as $site_mea)
                                                   {{ $site_mea->id === $site->id ? 'checked' : '' }}
                                               @endforeach
                                           @else
                                               checked
                                           @endif
                                           @if(auth_user()->getAccessLevel() > 1)
                                               required
                                            @endif
                                    >
                                    <label class="custom-control-label"
                                           for="site{{ $site->id }}">{{ $site->domaine_public }}</label>
                                </div>
                            @endforeach
                        </div>
                    </div>
                @endif

                <input type="hidden" name="type" value="{{ $mea->type !== null ? $mea->type : $type }}">
                {{ csrf_field() }}
            </form>
        </div>
    </div>
@endsection
