<?php
/**
 * Created by : loic
 * Created at : 21/04/2020
 *
 * In : IntelliJ IDEA
 */

namespace Bloom\CMS\Modules\Meas;

use Bloom\CMS\Modules\Architecture\Model\AdminMenu;
use Bloom\CMS\Modules\Architecture\Model\Module;
use Bloom\CMS\Modules\Architecture\Model\Page;
use Bloom\CMS\Modules\Meas\Http\Middleware\ModuleMiddleware;
use Bloom\CMS\Modules\Meas\Model\Mea;
use Illuminate\Database\Eloquent\Relations\Relation;
use Illuminate\Support\Facades\Route;
use Illuminate\Support\Facades\Schema;

class CmsMeasServiceProvider extends \Illuminate\Support\ServiceProvider
{

    public function register(): void
    {
        $this->loadFactoriesFrom(dirname(__DIR__) . '/database/factories');
        $this->loadMigrationsFrom(dirname(__DIR__) . '/database/migrations');
        $this->loadViewsFrom(dirname(__DIR__) . '/resources/views', 'Meas');
        $dirname = dirname(__DIR__) . '/routes';
        foreach (scandir($dirname) as $file) {
            if (!in_array($file, ['.', '..'])) {
                Route::group(['middleware' => ['web', ModuleMiddleware::class]], function () use ($dirname, $file) {
                    $this->loadRoutesFrom($dirname . '/' . $file);
                });
            }
        }

        $this->publishes([
            dirname(__DIR__) . '/public' => public_path('/vendor/cms-module-mea')
        ], 'assets');
    }

    public static function getModule()
    {
        if (Schema::hasTable('modules')) {
            $module = Module::nom('mea')->firstOrCreate([
                'nom'        => 'mea',
                'nom_public' => 'Accueil',
                'route'      => 'admin_mea_index',
            ]);
            if(!$module->exists) {
                $module->active = 1;
                $module->save();
            }
            return $module;
        }

        return false;
    }

    public function boot(): void
    {
        /**
         * @var Module $module
         */
        $module = self::getModule();

        if ($module && Schema::hasTable('admin_menus') && $module->subMenus->count() === 0) {
            AdminMenu::create([
                'module_id' => $module->id,
                'label'     => 'Visuel principal',
                'route'     => 'admin_mea_index',
                'active'    => 1,
            ]);
            AdminMenu::create([
                'module_id' => $module->id,
                'label'     => 'À l\'affiche',
                'route'     => 'admin_mea_aff',
                'active'    => 1,
            ]);
        }


        Relation::morphMap([
            'meas' => Mea::class,
        ]);
        self::getModule();
    }

}