<?php
/**
 * Created by : Jérôme
 * Created at : 19/06/2020
 *
 * In : IntelliJ IDEA
 */

namespace Bloom\CMS\Modules\Meas\Http\Controllers;

use Bloom\CMS\Core\Contenus\Statut;
use Bloom\CMS\Core\Helpers\Actions;
use Bloom\CMS\Core\Http\Page;
use Bloom\CMS\Modules\Meas\Model\Mea;
use Bloom\CMS\Modules\Meas\Model\Type;
use Carbon\Carbon;
use Illuminate\Routing\Controller;
use Illuminate\Support\Facades\Auth;

/**
 * Class AdminController
 * @package Bloom\CMS\Modules\Meas\Http\Controllers
 */
class AdminController extends Controller
{

    public function getSubMenu(): array
    {
        if (request('type')) {
            $type = request('type');
        } else {
            $type = request()->route()->getName() === 'admin_mea_index' ? Type::PRINCIPAL : Type::AFFICHE;
        }

        return [
            'sub_menu_items' => [
                [
                    'title'  => 'Publié' . ($type !== Type::PRINCIPAL ? 'es' : ''),
                    'href'   => $type === Type::PRINCIPAL ? route('admin_mea_index') : route('admin_mea_aff'),
                    'number' => Mea::type($type)->published()->count(),
                    'active' => request()->route()->getName() === 'admin_mea_index' || request()->route()->getName() === 'admin_mea_aff',
                ],
                [
                    'title'  => 'Programmé' . ($type !== Type::PRINCIPAL ? 'es' : 's'),
                    'href'   => route('admin_mea_programmes', $type),
                    'number' => Mea::type($type)->programmed()->count(),
                    'active' => request()->route()->getName() === 'admin_mea_programmes',
                ],
                [
                    'title'  => 'Non publié' . ($type !== Type::PRINCIPAL ? 'es' : 's'),
                    'href'   => route('admin_mea_encours', $type),
                    'number' => Mea::type($type)->status(Statut::EN_COURS)->notProgrammed()->count(),
                    'active' => request()->route()->getName() === 'admin_mea_encours',
                ],
            ]
        ];
    }

    public function getViewData(array $data): array
    {
        if (request('type')) {
            $data['type'] = request('type');
        } else {
            $data['type'] = request()->route()->getName() === 'admin_mea_index' ? Type::PRINCIPAL : Type::AFFICHE;
        }

        return array_merge($data, $this->getSubMenu());
    }

    public function getDefaultActions(bool $with_sub = true): array
    {
        $actions = new Actions();
        $actions
            ->addAction('Modifier', 'admin_mea_edit')
            ->addNewTabAction('Prévisualiser', 'admin_mea_preview')
            ->addAction('Publier', 'admin_mea_publish');
        if ($with_sub) {
            $sub_actions = new Actions('sub_actions');
            $sub_actions
                ->addAction('Supprimer', 'admin_mea_delete', 'bloomicon-trash-2');
        }

        return array_merge($actions->toArray(), isset($sub_actions) ? $sub_actions->toArray() : []);
    }

    public function index()
    {
        $actions = $this->getDefaultActions();

        // On remplace la 3eme action du menu
        $actions['actions'][2] = [
            'name' => 'Dépublier', 'href' => 'admin_mea_unpublish'
        ];
        $data['meas'] = Mea::type(Type::PRINCIPAL)->published()->orderBy('rank')->get();
        $data = array_merge($data, $actions);

        $data['type'] = Type::PRINCIPAL;
        $data['soustitre'] = 'Visuel principal';


        return view('Mea::admin.listing', $this->getViewData($data));
    }

    public function affiche()
    {
        $actions = $this->getDefaultActions();

        // On remplace la 3eme action du menu
        $actions['actions'][2] = [
            'name' => 'Dépublier', 'href' => 'admin_mea_unpublish'
        ];
        $data['meas'] = Mea::type(Type::AFFICHE)->published()->orderBy('rank')->get();
        $data = array_merge($data, $actions);

        $data['type'] = Type::AFFICHE;
        $data['soustitre'] = 'À l\'affiche';


        return view('Mea::admin.listing', $this->getViewData($data));
    }

    public function programmed()
    {
        $type = request('type', Type::PRINCIPAL);
        $data['meas'] = Mea::type($type)->programmed()->orderBy('rank')->get();
        $data = array_merge($data, $this->getDefaultActions());
        $data['soustitre'] = $type === Type::PRINCIPAL ? 'Visuel principal' : 'À l\'affiche';

        return view('Mea::admin.listing', $this->getViewData($data));
    }

    public function encours()
    {
        $type = request('type', Type::PRINCIPAL);
        $data['meas'] = Mea::type($type)->status(Statut::EN_COURS)->notProgrammed()->orderBy('rank')->get();
        $data = array_merge($data, $this->getDefaultActions());
        $data['soustitre'] = $type === Type::PRINCIPAL ? 'Visuel principal' : 'À l\'affiche';

        return view('Mea::admin.listing', $this->getViewData($data));
    }

    public function edit(Mea $mea)
    {
        $pages = Page::published()->get();
        $type = request('type', Type::PRINCIPAL);

        return view('Mea::admin.edit', compact('mea', 'pages', 'type'));
    }

    public function save(Mea $mea)
    {
        $user_id = Auth::user()->getAuthIdentifier();
        $type = request('type');

        if (request('statut_id')) {
            $statut = request('statut_id');
        } else {
            if ($mea !== null && $mea->count() > 0) {
                $statut = $mea->statut_id ?: Statut::EN_COURS;
            } else {
                $statut = Statut::EN_COURS;
            }
        }

        //Stockage des infos
        $mea->titre = request('titre');
        $mea->soustitre = request('soustitre');
        $mea->mentions = request('mentions');
        $mea->visuel_1 = request('visuel_1');
        $mea->visuel_2 = request('visuel_2');
        $mea->to_publish_at = request('date_pub');
        $mea->to_unpublish_at = request('date_depub');
        $mea->last_modified_by = $user_id;

        //Gestion du lien
        if (request('link_choice') && request('lien')) {

            if (request('page_id')) {
                $mea->page_id = request('page_id');
                $mea->href = null;
            }

            if (request('href')) {
                $parsed_link = parse_url(request('href'));
                $mea->href = empty($parsed_link['scheme']) ? 'http://' . request('href') : $mea->href = request('href');
                $mea->page_id = null;
            }
        } else {
            $mea->page_id = null;
            $mea->href = null;
        }


        //Gestion du statut en fonction de la date de publication
        if (request('date_pub') && Carbon::createFromFormat('Y-m-d', request('date_pub'))->isAfter(now())) {
            $statut = Statut::EN_COURS;
        } elseif (request('date_pub') && Carbon::createFromFormat('Y-m-d', request('date_pub'))->lessThanOrEqualTo(now())) {
            $statut = Statut::PUBLIE;
        }


        if (!$mea->exists) {
            //Nouvelle MEA
            $mea->created_by = $user_id;

            // Type MEA
            $mea->type = $type;

            if (request('statut_id') == Statut::PUBLIE) {
                $statut = Statut::PUBLIE;
                $mea->to_publish_at = now();
            }
            $mea->statut_id = $statut;


            //Gestion du rank
            $mea->rank = $mea->getRank();

            $mea->save();

        } else {
            // Edition

            $mea->statut_id = $statut;

            $mea->save();
        }

        //Redirection
        if ($statut == Statut::EN_COURS) {
            if ($mea->to_publish_at) {
                return redirect()->route('admin_mea_programmes', $mea->type);
            }

            return redirect()->route('admin_mea_encours', $mea->type);
        }

        if ($mea->type == Type::PRINCIPAL) {
            return redirect()->route('admin_mea_index');
        } else {
            return redirect()->route('admin_mea_aff');
        }

    }

    public function preview(Mea $mea)
    {
        $type = $mea->type;
        $meas = Mea::published()->orderBy('rank')->get();
        $last_mea = $meas->where('type', $type)->last();

        if ($meas->where('type', $type)->count() < Mea::MAX_RANK[ $type ]) {
            $mea->rank = $last_mea->rank + 1;
            $meas = $meas->push($mea);
        } else {
            $keys = $meas->where('type', $type)->keys()->last();
            $meas = $meas->forget($keys);
            $mea->rank = 4;
            $meas = $meas->push($mea);
        }

        return response(view('default', compact('meas')));
    }

    public function publish(Mea $mea)
    {
        $mea->publish();

        return redirect()->back();
    }

    public function unpublish(Mea $mea)
    {
        $mea->unpublish();

        return redirect()->back();
    }

    public function delete(Mea $mea)
    {
        $mea->softDelete();

        return redirect()->back();
    }

    public function reorder()
    {
        $ordre = request('ordre', []);

        $meas = Mea::published()->get();

        foreach ($meas as $mea) {
            /**
             * @var Mea $mea
             */
            $mea->rank = array_search($mea->id, $ordre, false);
            $mea->save();
        }
    }
}
