<?php
/**
 * Created by IntelliJ IDEA.
 * User: loic
 * Date: 25/06/20
 * Time: 12:16
 */

namespace Bloom\Cms\Modules\Leads\Extraction;


use Bloom\Cms\Modules\Leads\Model\Lead;

abstract class Extractor
{

    public function send(Lead $lead): bool
    {
        event('lead.extractor.sending', [$lead, class_basename($this)]);
        event('lead.extractor.sending.' . class_basename($this), $lead);
        try {
            $this->process($lead);
        } catch (\Throwable $e) {
            event('lead.extractor.error', [$lead, $e, class_basename($this)]);
            event('lead.extractor.error.' . class_basename($this), [$lead, $e]);
        }
        event('lead.extractor.sent', [$lead, class_basename($this)]);
        event('lead.extractor.sent.' . class_basename($this), $lead);

        return true;
    }

    /**
     * @param Lead $lead
     *
     * @throws ExtractionError
     */
    abstract protected function process(Lead $lead): void;
}
