<?php

/**
 * Created by IntelliJ IDEA.
 * User: loic
 * Date: 21/06/2021
 * Time: 12:21
 */

namespace Bloom\CMS\Modules\Conseiller\Model;

use Bloom\CMS\Core\Contenus\Contenu;
use Bloom\CMS\Core\Contenus\ContenuHandler;
use Bloom\CMS\Core\Contenus\IsContenu;
use Bloom\CMS\Core\Http\Page;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Collection;
use Illuminate\Database\Eloquent\Model;

/**
 * Class Conseiller
 * @package Bloom\CMS\Modules\Conseiller\Model
 *
 * @property string $departements
 * @property string $nom
 * @property string $prenom
 * @property string $tel
 * @property string $email
 */
class Conseiller extends Model implements Contenu
{
    use IsContenu;

    public function getHandler(): ContenuHandler
    {
        return new class implements ContenuHandler {

            public function single(Contenu $contenu)
            {
                /**
                 * @var Page $page
                 */
                $page = $contenu->page;

                return redirect($page->dossier->full_pathname . '?type=conseiller&selected=' . $contenu->id);
            }

            public function multiple(Collection $contenus)
            {
                // TODO: Implement multiple() method.
            }

            public function ensemble()
            {
                // TODO: Implement ensemble() method.
            }
        };
    }

    public function scopePublished(Builder $query)
    {
        return $this->scopeStatus($query, 1);
    }

    public function scopeArchived(Builder $query)
    {
        return $this->scopeStatus($query, 0);
    }

    public function scopeStatus(Builder $query, int $status)
    {
        return $query->whereHas(
            'page',
            function (Builder $query) use ($status) {
                return $query->where('statut_id', '=', $status);
            }
        );
    }

    public function scopeProgrammed(Builder $query)
    {
        return $query->whereHas(
            'page',
            function (Builder $query) {
                return $query->whereNotNull('to_publish_at')
                    ->where('statut_id', '=', 2);
            }
        );
    }

    public function scopeNotProgrammed(Builder $query)
    {
        return $query->whereHas(
            'page',
            function (Builder $query) {
                return $query->whereNull('to_publish_at');
            }
        );
    }
}
