@extends('bloom.layout.admin')

@section('bodyClass', 'page-edit page-agence')

@section('assets')
    @vite('resources/js/form.js', 'vendor/cms-module-conseiller')
    <script src="/plugins/ckeditor/ckeditor.js"></script>
    @include('ckfinder::setup')
@endsection

@section('content')
    <div class="container-fluid">
        <div id="navbar-btns" class="mb-5 heading-text d-flex justify-content-between align-items-center sticky-top">
            <h1>{{ $agence->exists ? 'Modifier' : 'Créer' }}
                une agence</h1>

            <span class="wrapper-btns ml-auto">
				<a href="{{ route('admin_conseil_agences') }}" class="btn-annuler btn btn-grisclair5 btn-primary">
					Annuler
				</a>
				<a href="javascript:void(0);" class="btn-valider btn btn-grisclair5 btn-primary"
                   onclick="$('.main form').submit()">
					Valider
				</a>
				<a href="javascript:void(0);" class="btn-publier btn btn-grisclair5 btn-primary"
                   onclick="publishAndSubmit()">
					Valider et publier
				</a>
			</span>
        </div>

        <div class="content">
            <form action="{{ route('admin_conseil_agence_save', $agence) }}" method="POST" id="form"
                  enctype="multipart/form-data">
                <div class="form-group row mb-0">
                    <div class="col-6 mb-4">
                        <x-forms.input-text
                            name="titre"
                            text="Titre"
                            :value="$page->titre ?? ''"
                            form="admin"
                        />
                    </div>

                    <div class="col-6 mb-4">
                        <x-forms.input-text
                            name="slug"
                            text="Slug"
                            :value="$page->slug ?? ''"
                            form="admin"
                        />
                    </div>
                </div>

                <div class="form-group mb-4">
                    <label for="vignette" class="control-label">Vignette</label>
                    <x-forms.input-custom-file-with-image
                        name="vignette"
                        text="Parcourir"
                        form="admin"
                        :required="true"
                        :value="$page->image_opengraph ?? ''"
                    />
                </div>

                <div class="form-group mb-0">
                    <div class="mb-4">
                        <div class="wrapper-editor">
                            <x-forms.editor
                                name="intro"
                                text="Introduction <em>(facultatif)</em>"
                                :value="$page->intro ?? ''"
                                form="admin"
                                format="mini"
                            />
                        </div>
                    </div>
                </div>

                <div class="form-group mb-0">
                    <div class="mb-4">
                        <div class="wrapper-editor">
                            <x-forms.editor
                                name="adresse"
                                text="Adresse"
                                :value="$agence->adresse ?? ''"
                                form="admin"
                                format="mini"
                                :max="1000"
                                :required="true"
                            />
                        </div>
                    </div>
                </div>

                <div class="form-group row mb-0">
                    <div class="col-6 mb-4">
                        <label for="telephone" class="control-label">
                            Email
                        </label>
                        <div class="wrapper-inputs">
                            <input type="text" value="{{ $agence->email ?? '' }}" name="email" required
                                   class="form-control"
                                   id="email" pattern="^[a-z0-9._%+-]+@[a-z0-9.-]+\.[a-z]{2,4}$"
                                   data-errormessage="Format email attendu.">
                        </div>
                    </div>


                    <div class="col-6 mb-4">
                        <label for="email" class="control-label">
                            Identifiant Apenday
                        </label>
                        <div class="wrapper-inputs">
                            <input type="text" value="{{ $agence->novadial ?? '' }}" name="novadial"
                                   class="form-control"
                                   id="novadial">
                        </div>
                    </div>
                </div>

                <div class="form-group row mb-0">
                    <div class="col-6 mb-4">
                        <x-forms.input-number
                            name="cp"
                            text="Code postal"
                            :value="$agence->cp ?? ''"
                            placeholder=""
                            form="admin"
                            :required="true"
                        />
                    </div>

                    <div class="col-6 mb-4">
                        <x-forms.input-text
                            name="ville"
                            text="Ville"
                            :value="$agence->ville ?? ''"
                            form="admin"
                            :required="true"
                        />
                    </div>
                    @php
                        $agenceCoordonnees = $agence->exists? $agence->getPositionAttribute() : null;
                    @endphp

                    <div class="col-6 mb-4">
                        <x-forms.input-number
                                name="point_lat"
                                text="Latitude"
                                :value="$agenceCoordonnees? $agenceCoordonnees->lat : ''"
                                placeholder=""
                                form="admin"
                                :required="true"
                        />
                    </div>

                    <div class="col-6 mb-4">
                        <x-forms.input-number
                                name="point_lng"
                                text="Longitude"
                                :value="$agenceCoordonnees? $agenceCoordonnees->lng : ''"
                                placeholder=""
                                form="admin"
                                :required="true"
                        />
                    </div>
                </div>

                <div class="accordion form-group mb-4" id="accordionConseiller">
                    <div class="card b-0 mb-4">
                        <div class="card-header b-0 mb-0" id="heading01">
							<span class="title-collapse d-block">
								<a href="#" class="d-flex" role="button" data-toggle="collapse"
                                   data-target="#collapseOne" aria-expanded="false" aria-controls="collapseOne">
									<span class="text">Horaires</span>
									<span class="bloomicon-admin-plus add" aria-hidden="true"></span>
									<span class="bloomicon-admin-minus remove" aria-hidden="true"></span>
								</a>
							</span>
                        </div>

                        <div id="collapseOne" class="collapse" aria-labelledby="heading01">
                            <div class="card-body p-0">
                                <div class="wrapper-exergue wrapper01-heading01">
                                    @php
                                        $horaires = [[
                                            "Lundi" => ["debut_matin" =>  "", "fin_matin" =>  "", "debut_am" =>  "", "fin_am" =>  ""],
                                            "Mardi" =>  ["debut_matin" =>  "", "fin_matin" =>  "", "debut_am" =>  "", "fin_am" =>  ""],
                                            "Mercredi" => ["debut_matin" =>  "", "fin_matin" =>  "", "debut_am" =>  "", "fin_am" =>  ""],
                                            "Jeudi" => ["debut_matin" =>  "", "fin_matin" =>  "", "debut_am" =>  "", "fin_am" =>  ""],
                                            "Vendredi" => ["debut_matin" =>  "", "fin_matin" =>  "", "debut_am" =>  "", "fin_am" =>  ""],
                                            "Samedi" => ["debut_matin" =>  "", "fin_matin" =>  "", "debut_am" =>  "", "fin_am" =>  ""]
                                        ]];
                                    @endphp

                                    @if($agence->exists)
                                        @php($horaires = $agence->horaires)
                                    @endif

                                    @foreach($horaires[0] as $name => $horaire)
                                        <div
                                            class="form-group row align-items-center @if(!$loop->first) mt-2 @endif mb-0">
                                            <div class="col-1">
                                                <label class="control-label text-gris4">{{ ucwords($name) }}</label>
                                            </div>

                                            <div class="col-5 wrapper-group{{ $loop->index }}-1">
                                                <div class="row justify-content-center align-items-center py-2">
                                                    <x-forms.input-time
                                                        :name="'hour0' . $loop->index . '_01'"
                                                        :value="$horaire['debut_matin']"
                                                        placeholder="de"
                                                        form="admin"
                                                    />
                                                    <x-forms.input-time
                                                        :name="'hour0' . $loop->index . '_02'"
                                                        :value="$horaire['fin_matin']"
                                                        placeholder="à"
                                                        form="admin"
                                                    />
                                                </div>
                                            </div>

                                            <div class="col-1">
                                                <label
                                                    class="control-label text-gris4 justify-content-center align-items-center">et</label>
                                            </div>

                                            <div class="col-5 wrapper-group{{ $loop->index }}-2">
                                                <div class="row justify-content-center align-items-center py-2">
                                                    <x-forms.input-time
                                                        :name="'hour0' . $loop->index . '_03'"
                                                        :value="$horaire['debut_am']"
                                                        placeholder="de"
                                                        form="admin"
                                                    />
                                                    <x-forms.input-time
                                                        :name="'hour0' . $loop->index . '_04'"
                                                        :value="$horaire['fin_am']"
                                                        placeholder="à"
                                                        form="admin"
                                                    />
                                                </div>
                                            </div>
                                        </div>
                                    @endforeach
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="form-group mb-0">
                    <div class="mb-4">
                        <div class="wrapper-editor">
                            <x-forms.editor
                                name="mentions"
                                text="Mentions <em>(facultatif)</em>"
                                :value="$page->mentions ?? ''"
                                form="admin"
                                format="mini"
                            />
                        </div>
                    </div>
                </div>

                <input type="hidden" name="statut_id" value="{{ $page->statut_id ?? '' }}">
                {{ csrf_field() }}
            </form>
        </div>
    </div>
@endsection
