<?php

/**
 * Created by IntelliJ IDEA.
 * User: loic
 * Date: 21/06/2021
 * Time: 10:12
 */

namespace Bloom\CMS\Modules\Conseiller;

use Bloom\CMS\Core\BloomProvider;
use Bloom\CMS\Core\Contenus\Statut;
use Bloom\CMS\Core\Framework\Admin\AdminMenu;
use Bloom\CMS\Core\Helpers\Actions;
use Bloom\CMS\Core\Helpers\TableHeader;
use Bloom\CMS\Core\Helpers\Workflow;
use Bloom\CMS\Core\Helpers\WorkflowsFactory;
use Bloom\CMS\Core\Http\Page;
use Bloom\CMS\Modules\Conseiller\Model\Agence;
use Bloom\CMS\Modules\Conseiller\Model\Conseiller;
use Illuminate\Database\Eloquent\Relations\Relation;
use Illuminate\Support\Facades\Route;
use Illuminate\Support\Facades\Schema;

/**
 * Class CmsConseillerServiceProvider
 * @package Bloom\CMS\Modules\Conseiller
 */
class CmsConseillerServiceProvider extends BloomProvider
{
    protected $nom = "Agences et Conseillers";
    protected $code = "conseil";

    public function boot()
    {
        parent::boot();

        $this->registerDossier(
            Conseiller::class,
            'Agences et Conseillers',
            'FrontController@index',
            'Gérer',
            'admin_conseil_index'
        );

        // Déclaration contenu
        $morph = [
            'conseillers' => Conseiller::class,
            'agences'     => Agence::class,
        ];
        Relation::morphMap($morph);
        foreach (array_keys($morph) as $name) {
            Page::declareContenu($name);
        }

        $this->addSubMenus(
            [
                new AdminMenu(['label' => 'Conseillers', 'route' => 'admin_conseil_index',]),
                new AdminMenu(['label' => 'Agences', 'route' => 'admin_conseil_agences',]),
            ]
        );

        $this->registerRoute(
            function () {
                Route::get('/agences/{workflow:code?}', 'AdminAgenceController@listing')->name('agences');
            },
            true
        );

        $factory_conseiller = new WorkflowsFactory(Conseiller::class);
        $this->declareConseillerPublishedWorkflow($factory_conseiller);
        $this->declareConseillerProgrammedWorkflow($factory_conseiller);
        $this->declareConseillerEnCoursWorkflow($factory_conseiller);
        $this->declareConseillerArchivedWorkflow($factory_conseiller);
        $this->haveGenericIndex($factory_conseiller);

        $factory_agence = new WorkflowsFactory(Agence::class);
        $this->declareAgencePublishedWorkflow($factory_agence);
        $this->declareAgenceProgrammedWorkflow($factory_agence);
        $this->declareAgenceEnCoursWorkflow($factory_agence);
        $this->declareAgenceArchivedWorkflow($factory_agence);
        $this->setGenericIndexAgence($factory_agence);
    }

    //#region Conseiller Workflow

    public function declareConseillerPublishedWorkflow(WorkflowsFactory $factory)
    {
        $factory
            ->add('Publiés', "CONSEIL_PUB")
            ->statement(
                "SELECT conseillers.*
                            FROM conseillers
                            JOIN pages ON conseillers.id = pages.contenu_id AND pages.contenu_type = 'conseillers'
                            WHERE pages.statut_id = " . Statut::PUBLIE . " ORDER BY conseillers.updated_at DESC"
            )
            ->edition('admin_conseil_conseiller_edit', 'Créer un conseiller')
            ->setAction(
                (new Actions())
                    ->addAction('Modifier', 'admin_conseil_conseiller_edit')
                    ->addNewTabAction('Prévisualiser', 'admin_conseil_conseiller_preview')
            )->setSubActions(
                (new Actions())
                    ->addAction('Dupliquer', 'admin_conseil_conseiller_duplicate', 'bloomicon-admin-copy')
                    ->addAction('Dépublier', 'admin_conseil_conseiller_unpublish', 'bloomicon-admin-arrow-down-left')
                    ->addAction('Archiver', 'admin_conseil_conseiller_archive', 'bloomicon-admin-archive')
            )->setHeaders(
                [
                    (new TableHeader('Vignette', 'page.image_opengraph'))->isImage(),
                    (new TableHeader('Id', 'id'))->canOrder(),
                    (new TableHeader('Titre', 'page.titre'))->canOrder(),
                    (new TableHeader('Créé le', 'created_at'))->canOrder()->haveTitle('page.cree_par.name'),
                    (new TableHeader('Modifié le', 'updated_at'))->canOrder()->haveTitle(
                        'page.derniere_modification_par.name'
                    ),
                    (new TableHeader('Dates de<br> publication', 'page.to_publish_at'))->canOrder(),
                ]
            )
            ->push();
    }

    public function declareConseillerProgrammedWorkflow(WorkflowsFactory $factory)
    {
        $factory
            ->add('Programmés', "CONSEIL_PROGRAMMED")
            ->statement(
                "SELECT conseillers.*
                            FROM conseillers
                            JOIN pages ON conseillers.id = pages.contenu_id AND pages.contenu_type = 'conseillers'
                            WHERE pages.statut_id = " . Statut::EN_COURS . " AND pages.to_publish_at IS NOT NULL
                            ORDER BY pages.to_publish_at DESC"
            )
            ->edition('admin_conseil_conseiller_edit', 'Créer un conseiller')
            ->setAction(
                (new Actions())
                    ->addAction('Modifier', 'admin_conseil_conseiller_edit')
                    ->addNewTabAction('Prévisualiser', 'admin_conseil_conseiller_preview')
            )->setSubActions(
                (new Actions())
                    ->addAction('Dupliquer', 'admin_conseil_conseiller_duplicate', 'bloomicon-admin-copy')
                    ->addAction('Publier', 'admin_conseil_conseiller_publish', 'bloomicon-admin-arrow-up-right')
                    ->addAction('Archiver', 'admin_conseil_conseiller_archive', 'bloomicon-admin-archive')
            )->setHeaders(
                [
                    (new TableHeader('Vignette', 'page.image_opengraph'))->isImage(),
                    (new TableHeader('Id', 'id'))->canOrder(),
                    (new TableHeader('Titre', 'page.titre'))->canOrder(),
                    (new TableHeader('Créé le', 'created_at'))->canOrder()->haveTitle('page.cree_par.name'),
                    (new TableHeader('Modifié le', 'updated_at'))->canOrder()->haveTitle(
                        'page.derniere_modification_par.name'
                    ),
                    (new TableHeader('Dates de<br> publication', 'page.to_publish_at'))->canOrder(),
                ]
            )
            ->push();
    }

    public function declareConseillerEnCoursWorkflow(WorkflowsFactory $factory)
    {
        $factory
            ->add('En cours de rédaction', "CONSEIL_EN_COURS")
            ->statement(
                "SELECT conseillers.*
                            FROM conseillers
                            JOIN pages ON conseillers.id = pages.contenu_id AND pages.contenu_type = 'conseillers'
                            WHERE pages.statut_id = " . Statut::EN_COURS . " AND pages.to_publish_at IS NULL
                            ORDER BY updated_at DESC"
            )
            ->edition('admin_conseil_conseiller_edit', 'Créer un conseiller')
            ->setAction(
                (new Actions())
                    ->addAction('Modifier', 'admin_conseil_conseiller_edit')
                    ->addNewTabAction('Prévisualiser', 'admin_conseil_conseiller_preview')
            )->setSubActions(
                (new Actions())
                    ->addAction('Dupliquer', 'admin_conseil_conseiller_duplicate', 'bloomicon-admin-copy')
                    ->addAction('Publier', 'admin_conseil_conseiller_publish', 'bloomicon-admin-arrow-up-right')
                    ->addAction('Archiver', 'admin_conseil_conseiller_archive', 'bloomicon-admin-archive')
            )->setHeaders(
                [
                    (new TableHeader('Vignette', 'page.image_opengraph'))->isImage(),
                    (new TableHeader('Id', 'id'))->canOrder(),
                    (new TableHeader('Titre', 'page.titre'))->canOrder(),
                    (new TableHeader('Créé le', 'created_at'))->canOrder()->haveTitle('page.cree_par.name'),
                    (new TableHeader('Modifié le', 'updated_at'))->canOrder()->haveTitle(
                        'page.derniere_modification_par.name'
                    ),
                    (new TableHeader('Dates de<br> publication', 'page.to_publish_at'))->canOrder(),
                ]
            )
            ->push();
    }

    public function declareConseillerArchivedWorkflow($factory)
    {
        $factory
            ->add('Archivés', "CONSEIL_ARCHIVED")
            ->statement(
                "SELECT conseillers.*
                                FROM conseillers
                                JOIN pages ON conseillers.id = pages.contenu_id AND pages.contenu_type = 'conseillers'
                                WHERE pages.statut_id = " . Statut::ARCHIVE . "
                                ORDER BY pages.updated_at DESC"
            )
            ->edition('admin_conseil_conseiller_edit', 'Créer un conseiller')
            ->setAction(
                (new Actions())
                    ->addAction('Désarchiver', 'admin_conseil_conseiller_unpublish')
                    ->addAction('Supprimer', 'admin_conseil_conseiller_delete')
            )->setSubActions(
                (new Actions())
                    ->addAction('Dupliquer', 'admin_conseil_conseiller_duplicate', 'bloomicon-admin-copy')
            )->setHeaders(
                [
                    (new TableHeader('Vignette', 'page.image_opengraph'))->isImage(),
                    (new TableHeader('Id', 'id'))->canOrder(),
                    (new TableHeader('Titre', 'page.titre'))->canOrder(),
                    (new TableHeader('Créé le', 'created_at'))->canOrder()->haveTitle('page.cree_par.name'),
                    (new TableHeader('Modifié le', 'updated_at'))->canOrder()->haveTitle(
                        'page.derniere_modification_par.name'
                    ),
                    (new TableHeader('Dates de<br> publication', 'page.to_publish_at'))->canOrder(),
                ]
            )
            ->push();
    }

    //#endregion

    //#region Agence Workflow

    public function declareAgencePublishedWorkflow(WorkflowsFactory $factory)
    {
        $factory
            ->add('Publiés', "AGENCE_PUB")
            ->statement(
                "SELECT agences.*
                            FROM agences
                            JOIN pages ON agences.id = pages.contenu_id AND pages.contenu_type = 'agences'
                            WHERE pages.statut_id = " . Statut::PUBLIE . " ORDER BY agences.updated_at DESC"
            )
            ->edition('admin_conseil_agence_edit', 'Créer une agence')
            ->setAction(
                (new Actions())
                    ->addAction('Modifier', 'admin_conseil_agence_edit')
                    ->addNewTabAction('Prévisualiser', 'admin_conseil_agence_preview')
            )->setSubActions(
                (new Actions())
                    ->addAction('Dépublier', 'admin_conseil_agence_unpublish', 'bloomicon-admin-arrow-down-left')
                    ->addAction('Archiver', 'admin_conseil_agence_archive', 'bloomicon-admin-archive')
            )->setHeaders(
                [
                    (new TableHeader('Vignette', 'page.image_opengraph'))->isImage(),
                    (new TableHeader('Id', 'id'))->canOrder(),
                    (new TableHeader('Titre', 'page.titre'))->canOrder(),
                    (new TableHeader('Créé le', 'created_at'))->canOrder()->haveTitle('page.cree_par.name'),
                    (new TableHeader('Modifié le', 'updated_at'))->canOrder()->haveTitle(
                        'page.derniere_modification_par.name'
                    ),
                    (new TableHeader('Dates de<br> publication', 'page.to_publish_at'))->canOrder(),
                ]
            )
            ->push();
    }

    public function declareAgenceProgrammedWorkflow(WorkflowsFactory $factory)
    {
        $factory
            ->add('Programmés', "AGENCE_PROGRAMMED")
            ->statement(
                "SELECT agences.*
                            FROM agences
                            JOIN pages ON agences.id = pages.contenu_id AND pages.contenu_type = 'agences'
                            WHERE pages.statut_id = " . Statut::EN_COURS . " AND pages.to_publish_at IS NOT NULL
                            ORDER BY pages.to_publish_at DESC"
            )
            ->edition('admin_conseil_agence_edit', 'Créer une agence')
            ->setAction(
                (new Actions())
                    ->addAction('Modifier', 'admin_conseil_agence_edit')
                    ->addNewTabAction('Prévisualiser', 'admin_conseil_agence_preview')
            )->setSubActions(
                (new Actions())
                    ->addAction('Publier', 'admin_conseil_agence_publish', 'bloomicon-admin-arrow-up-right')
                    ->addAction('Archiver', 'admin_conseil_agence_archive', 'bloomicon-admin-archive')
            )->setHeaders(
                [
                    (new TableHeader('Vignette', 'page.image_opengraph'))->isImage(),
                    (new TableHeader('Id', 'id'))->canOrder(),
                    (new TableHeader('Titre', 'page.titre'))->canOrder(),
                    (new TableHeader('Créé le', 'created_at'))->canOrder()->haveTitle('page.cree_par.name'),
                    (new TableHeader('Modifié le', 'updated_at'))->canOrder()->haveTitle(
                        'page.derniere_modification_par.name'
                    ),
                    (new TableHeader('Dates de<br> publication', 'page.to_publish_at'))->canOrder(),
                ]
            )
            ->push();
    }

    public function declareAgenceEnCoursWorkflow(WorkflowsFactory $factory)
    {
        $factory
            ->add('En cours de rédaction', "AGENCE_EN_COURS")
            ->statement(
                "SELECT agences.*
                            FROM agences
                            JOIN pages ON agences.id = pages.contenu_id AND pages.contenu_type = 'agences'
                            WHERE pages.statut_id = " . Statut::EN_COURS . " AND pages.to_publish_at IS NULL
                            ORDER BY updated_at DESC"
            )
            ->edition('admin_conseil_agence_edit', 'Créer une agence')
            ->setAction(
                (new Actions())
                    ->addAction('Modifier', 'admin_conseil_agence_edit')
                    ->addNewTabAction('Prévisualiser', 'admin_conseil_agence_preview')
            )->setSubActions(
                (new Actions())
                    ->addAction('Publier', 'admin_conseil_agence_publish', 'bloomicon-admin-arrow-up-right')
                    ->addAction('Archiver', 'admin_conseil_agence_archive', 'bloomicon-admin-archive')
            )->setHeaders(
                [
                    (new TableHeader('Vignette', 'page.image_opengraph'))->isImage(),
                    (new TableHeader('Id', 'id'))->canOrder(),
                    (new TableHeader('Titre', 'page.titre'))->canOrder(),
                    (new TableHeader('Créé le', 'created_at'))->canOrder()->haveTitle('page.cree_par.name'),
                    (new TableHeader('Modifié le', 'updated_at'))->canOrder()->haveTitle(
                        'page.derniere_modification_par.name'
                    ),
                    (new TableHeader('Dates de<br> publication', 'page.to_publish_at'))->canOrder(),
                ]
            )
            ->push();
    }

    public function declareAgenceArchivedWorkflow($factory)
    {
        $factory
            ->add('Archivés', "AGENCE_ARCHIVED")
            ->statement(
                "SELECT agences.*
                                FROM agences
                                JOIN pages ON agences.id = pages.contenu_id AND pages.contenu_type = 'agences'
                                WHERE pages.statut_id = " . Statut::ARCHIVE . "
                                ORDER BY pages.updated_at DESC"
            )
            ->edition('admin_conseil_agence_edit', 'Créer une agence')
            ->setAction(
                (new Actions())
                    ->addAction('Désarchiver', 'admin_conseil_agence_unpublish')
                    ->addAction('Supprimer', 'admin_conseil_agence_delete')
            )->setHeaders(
                [
                    (new TableHeader('Vignette', 'page.image_opengraph'))->isImage(),
                    (new TableHeader('Id', 'id'))->canOrder(),
                    (new TableHeader('Titre', 'page.titre'))->canOrder(),
                    (new TableHeader('Créé le', 'created_at'))->canOrder()->haveTitle('page.cree_par.name'),
                    (new TableHeader('Modifié le', 'updated_at'))->canOrder()->haveTitle(
                        'page.derniere_modification_par.name'
                    ),
                    (new TableHeader('Dates de<br> publication', 'page.to_publish_at'))->canOrder(),
                ]
            )
            ->push();
    }

    protected function setGenericIndexAgence(WorkflowsFactory $factory)
    {
        // On sauvegarde les workflows si il n'existe pas
        if (Schema::hasTable('workflows') && Workflow::isModule($this->module)->where('code','like','AGENCE%')->count() === 0) {
            $factory->saveFor($this->module);
        }
    }
    //#endregion
}
