@extends('bloom.layout.admin')

@section('bodyClass', 'page-edit')

@section('assets')
    @vite('resources/js/form.js', 'vendor/cms-module-conseil')
    <script src="/plugins/ckeditor/ckeditor.js"></script>
    <script type="text/javascript" src="/js/ckfinder/ckfinder.js"></script>
    <script>CKFinder.config({connectorPath: '/ckfinder/connector'});</script>
@endsection

@section('content')
    @php($pageConseiller = isset($conseiller) ? $conseiller->page : '')

    <div class="container-fluid">
        <div id="navbar-btns" class="mb-5 heading-text d-flex justify-content-between align-items-center sticky-top">
            <h1>{{ $conseiller->exists() ? 'Modifier' : 'Ajouter' }} un conseiller</h1>
            <span class="wrapper-btns ml-auto">
                <a href="{{ route('admin_conseil_index') }}" class="btn-annuler btn btn-grisclair5 btn-primary">
                    Annuler
                </a>
                <a href="javascript:void(0);" class="btn-valider submit btn btn-grisclair5 btn-primary"
                   onclick="$('.main form').submit()">
                    Valider
                </a>
                <a href="javascript:void(0);" class="btn-publier submit btn btn-grisclair5 btn-primary"
                   onclick="publishAndSubmit()">
                    Valider et publier
                </a>
            </span>
        </div>

        <div class="content">
            <form action="{{ route('admin_conseil_conseiller_save', $conseiller) }}" method="POST" id="form">
                {{ csrf_field() }}
                <div class="form-group row mb-0">
                    <div class="col-6 mb-4">
                        <x-forms.input-text
                                name="titre"
                                text="Titre"
                                :value="$pageConseiller->titre"
                                form="admin"
                        />
                    </div>

                    <div class="col-6 mb-4">
                        <x-forms.input-text
                                name="slug"
                                text="Slug"
                                :value="$pageConseiller->slug"
                                form="admin"
                        />
                    </div>
                </div>

                <div class="form-group row mb-0">
                    <div class="col-6 mb-4">
                        <x-forms.input-text
                                name="nom"
                                text="Nom"
                                :value="$conseiller->nom"
                                form="admin"
                                :required="true"
                        />
                    </div>
                    <div class="col-6 mb-4">
                        <x-forms.input-text
                                name="prenom"
                                text="Prénom"
                                :value="$conseiller->prenom"
                                form="admin"
                                :required="true"
                        />
                    </div>
                </div>

                <div class="form-group row mb-0">
                    <div class="col-12 mb-4">
                        <label for="vignette" class="control-label">Photo <em>(facultatif)</em></label>
                        <x-forms.input-custom-file-with-image
                                name="vignette"
                                text="Parcourir"
                                form="admin"
                                :required="false"
                                :value="$pageConseiller->image_opengraph"
                        />
                    </div>
                </div>

                <div class="form-group row mb-0">
                    <div class="col-12 mb-4">
                        <div class="wrapper-editor">
                            <x-forms.editor
                                    name="intro"
                                    text="Introduction <em>(facultatif)</em>"
                                    :value="$pageConseiller->intro"
                                    form="admin"
                                    format="mini"
                                    :max="10000"
                            />
                        </div>
                    </div>
                </div>

                <div class="form-group row mb-0">
                    <div class="col-4 mb-4">
                        <label for="telephone" class="control-label">
                            N° de téléphone
                        </label>
                        <div class="wrapper-inputs">
                            <input type="text" value="{{ $conseiller->tel }}" name="tel" required class="form-control"
                                   id="telephone" pattern="^(?:0|\(?\+33\)?\s?|0033\s?)[1-79](?:[\.\-\s]?\d\d){4}$"
                                   data-errormessage="Format +33XXXXXXXXX ou 0XXXXXXXXX attendu.">
                        </div>
                    </div>
                    <div class="col-4 mb-4">
                        <label for="email" class="control-label">
                            Email
                        </label>
                        <div class="wrapper-inputs">
                            <input type="text" value="{{ $conseiller->email }}" name="email" required
                                   class="form-control"
                                   id="email" pattern="^[a-z0-9._%+-]+@[a-z0-9.-]+\.[a-z]{2,4}$"
                                   data-errormessage="Format email attendu.">
                        </div>
                    </div>
                    <div class="col-4 mb-4">
                        <label for="email" class="control-label">
                            Identifiant Apenday
                        </label>
                        <div class="wrapper-inputs">
                            <input type="text" value="{{ $conseiller->novadial }}" name="novadial" class="form-control"
                                   id="novadial">
                        </div>
                    </div>
                    <div class="col-4 mb-4">
                        <label for="departements" class="control-label">
                            N° des départements couverts (séparés par des virgules)
                        </label>
                        <div class="wrapper-inputs">
                            <input type="text" value="{{ $conseiller->departements }}" name="departements" required
                                   class="form-control" id="departements" pattern="^([0-9]{2},?|2[abAB],?|97[1-6],?)+$"
                                   data-errormessage="Numéros des départements couverts, séparés par des virgules">
                        </div>
                    </div>
                </div>

                <div class="form-group">
                    <div class="mb-4">
                        <div class="wrapper-editor">
                            <x-forms.editor
                                    name="mentions"
                                    text="Mentions légales <em>(facultatif)</em>"
                                    :value="$pageConseiller->mentions"
                                    form="admin"
                                    format="mini"
                                    :max="10000"
                            />
                        </div>
                    </div>
                </div>

                <div class="form-group mb-4">
                    <label class="control-label" for="date_pub">Dates de publication</label>
                    <div class="row w-75">
                        {{--{{ field.calendrier('conseiller','date_pub','date_depub') }}--}}
                    </div>
                </div>

                <input type="hidden" name="statut_id" value="{{ $pageConseiller->statut_id }}">
                {{ csrf_field() }}
            </form>
        </div>
    </div>
@endsection