<?php

/**
 * Created by IntelliJ IDEA.
 * User: loic
 * Date: 23/06/2021
 * Time: 11:49
 */

namespace Bloom\CMS\Modules\Conseiller\Http\Controllers;

use Bloom\CMS\Core\Contenus\Statut;
use Bloom\CMS\Core\Helpers\Workflow;
use Bloom\CMS\Core\Http\Dossier;
use Bloom\CMS\Core\Http\Page;
use Bloom\CMS\Modules\Conseiller\Model\Conseiller;
use Carbon\Carbon;
use Illuminate\Routing\Controller;
use Illuminate\Support\Facades\Auth;

class AdminConseillerController extends Controller
{
    public function edit(Conseiller $conseiller)
    {
        $page = $conseiller->page;
        if (request('dossier_id')) {
            if ($page === null) {
                $page = new Page();
            }
            $page->dossier_id = Dossier::query()->where('type', '=', Conseiller::class)->first()->id;
        }

        return view('Conseil::admin.edit_conseiller', compact('conseiller', 'page'));
    }

    public function save(Conseiller $conseiller)
    {
        $user_id = Auth::user()->getAuthIdentifier();
        $dossier = Dossier::where('type', '=', Conseiller::class)->first();

        if (request('statut_id')) {
            $statut = request('statut_id');
        } elseif ($conseiller->page !== null) {
            $statut = $conseiller->page->statut_id ?: Statut::EN_COURS;
        } else {
            $statut = Statut::EN_COURS;
        }

        $conseiller->email = request('email');
        $conseiller->departements = request('departements');
        $conseiller->nom = request('nom');
        $conseiller->prenom = request('prenom');
        $conseiller->tel = request('tel');
        if (!$conseiller->exists) {
            $conseiller->save();


            // On crée la page
            $page = new Page();
            $page->titre = request('titre');
            $page->slug = request('slug');
            $page->meta_titre = '';
            $page->meta_description = '';
            $page->created_by = $user_id;
            $page->last_modified_by = $user_id;
            $page->intro = request('intro');
            $page->dossier()->associate($dossier);
            $page->to_publish_at = request('date_pub');
            $page->to_unpublish_at = request('date_depub');
            $page->multiplicity = Page::SINGLE;
            $page->image_opengraph = request('vignette');
            $page->mentions = request('mentions');

            if (request('date_pub') && Carbon::createFromFormat('Y-m-d', request('date_pub'))->isAfter(now())) {
                $statut = Statut::EN_COURS;
            }
            if (request('statut_id') == Statut::EN_COURS) {
                $statut = Statut::PUBLIE;
                $page->to_publish_at = now();
            }

            $page->statut_id = $statut;
            // On attache la page et l'article
            $page->contenu()->associate($conseiller);
            $page->save();
        } else {
            /**
             * @var Page $page
             */
            $page = $conseiller->page;

            if ($conseiller->isDirty()) {
                // On mets à jour la page
                $page->last_modified_by = $user_id;
                $conseiller->save();
            }

            $page->titre = request('titre');
            $page->slug = request('slug');
            $page->intro = request('intro');
            $page->to_publish_at = request('date_pub');
            $page->to_unpublish_at = request('date_depub');
            $page->image_opengraph = request('vignette');
            $page->mentions = request('mentions');

            if (request('date_pub') && Carbon::createFromFormat('Y-m-d', request('date_pub'))->isAfter(now())) {
                $statut = Statut::EN_COURS;
            }
            if (request('statut_id') == Statut::PUBLIE) {
                $statut = Statut::PUBLIE;
                $page->to_publish_at = now();
            }
            $page->statut_id = $statut;

            if ($page->isDirty()) {
                $page->last_modified_by = $user_id;
                $page->save();
                $conseiller->touch();
            }
        }

        if ($statut == Statut::EN_COURS) {
            return redirect()->route(
                'admin_conseil_index',
                Workflow::query()->where('code', '=', 'CONSEIL_EN_COURS')->first()
            );
        }

        if ($statut == Statut::ARCHIVE) {
            return redirect()->route(
                'admin_conseil_index',
                Workflow::query()->where('code', '=', 'CONSEIL_ARCHIVES')->first()
            );
        }

        return redirect()->route('admin_conseil_index');
    }

    public function preview(Conseiller $conseiller)
    {
        return $conseiller->getHandler()->single($conseiller);
    }

    public function publish(Conseiller $conseiller)
    {
        /**
         * @var Page $page
         */
        $page = $conseiller->page;
        $page->publish();

        return redirect()->back();
    }

    public function unpublish(Conseiller $conseiller)
    {
        /**
         * @var Page $page
         */
        $page = $conseiller->page;
        $page->unpublish();

        return redirect()->back();
    }

    public function archive(Conseiller $conseiller)
    {
        /**
         * @var Page $page
         */
        $page = $conseiller->page;
        $page->archive();

        return redirect()->back();
    }

    public function duplicate(Conseiller $conseiller)
    {
        $dub = $conseiller->replicate(['created_at', 'updated_at', 'created_by', 'last_modified_by']);
        $dub->nom = $conseiller->nom . ' - Copie';
        $dub->save();

        $page = new Page();
        $page->titre = $conseiller->page->titre . " - Copie";
        $page->slug = $conseiller->page->slug . "-copie";
        $page->meta_description = "";
        $page->intro = $conseiller->page->intro;
        $page->image_opengraph = $conseiller->page->image_opengraph;
        $page->mentions = $conseiller->page->mentions;
        $page->meta_titre = "";
        $page->multiplicity = "1";
        $page->statut_id = $conseiller->page->statut_id;
        $page->to_publish_at = $conseiller->page->to_publish_at;
        $page->to_unpublish_at = $conseiller->page->to_unpublish_at;
        $page->dossier_id = $conseiller->page->dossier_id;
        $page->contenu()->associate($dub);
        $page->save();

        return redirect()->back();
    }

    public function delete(Conseiller $conseiller)
    {
        /**
         * @var Page $page
         */
        $page = $conseiller->page;
        $page->softDelete();

        return redirect()->back();
    }
}
