<?php

/**
 * Created by IntelliJ IDEA.
 * User: loic
 * Date: 21/06/2021
 * Time: 12:21
 */

namespace Bloom\CMS\Modules\Conseiller\Model;

use Bloom\CMS\Core\Contenus\Contenu;
use Bloom\CMS\Core\Contenus\ContenuHandler;
use Bloom\CMS\Core\Contenus\IsContenu;
use Bloom\CMS\Core\Http\Page;
use Bloom\CMS\Modules\Conseiller\Geo\Point;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Collection;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Http\Response;
use Illuminate\Support\Facades\DB;
use Illuminate\View\View;

/**
 * Class Agence
 * @package Bloom\CMS\Modules\Conseiller\Model
 *
 * @property int    $id
 * @property string $adresse
 * @property string $cp
 * @property string $ville
 * @property int    $rank
 * @property Point  $position
 * @property string $horaires
 * @property string $email
 */
class Agence extends Model implements Contenu
{
    use IsContenu;

    protected $casts = [
        'horaires' => 'array',
    ];

    public function getHandler(): ContenuHandler
    {
        return new class implements ContenuHandler {

            public function single(Contenu $contenu)
            {
                /**
                 * @var Page $page
                 */
                $page = $contenu->page;

                return redirect($page->dossier->full_pathname . '?type=agence&selected=' . $contenu->id);
            }

            public function multiple(Collection $contenus)
            {
                // TODO: Implement multiple() method.
            }

            public function ensemble()
            {
                // TODO: Implement ensemble() method.
            }
        };
    }


    public function getPositionAttribute(): Point
    {
        $point = new Point();
        if ($this->exists) {
            $values = DB::table($this->getTable())
                ->selectRaw('ST_Y(position) as lat, ST_X(position) as lng')->where('id', '=', $this->id)->first();
            $point->lat = $values->lat;
            $point->lng = $values->lng;
        }

        return $point;
    }

    /**
     * @param Point $point
     * @throws \Exception
     */
    public function setPositionAttribute(Point $point)
    {
        if (!empty($point->lng) && !empty($point->lat) && str_contains($point->lng, '.') && str_contains($point->lat, '.') ) {
            $this->attributes['position'] = DB::raw(
                "ST_GeomFromText('POINT(" . $point->lat . " " . $point->lng . ")',4326)"
            );
        }
        else{
            throw new \Exception('La latitude ou la longitude n\'est pas valide');
        }
    }

    public function scopePublished(Builder $query)
    {
        return $this->scopeStatus($query, 1);
    }


    public function scopeArchived(Builder $query)
    {
        return $this->scopeStatus($query, 0);
    }

    public function scopeStatus(Builder $query, int $status)
    {
        return $query->whereHas(
            'page',
            function (Builder $query) use ($status) {
                return $query->where('statut_id', '=', $status);
            }
        );
    }

    public function scopeProgrammed(Builder $query)
    {
        return $query->whereHas(
            'page',
            function (Builder $query) {
                return $query->whereNotNull('to_publish_at')
                    ->where('statut_id', '=', 2);
            }
        );
    }

    public function scopeNotProgrammed(Builder $query)
    {
        return $query->whereHas(
            'page',
            function (Builder $query) {
                return $query->whereNull('to_publish_at');
            }
        );
    }
}
